/***************************************************
 * Automatically generated by Maple.
 * Created On: Thu May 04 11:06:18 2023.
***************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

/***************************************************
* Variable Definition for System:

* State variable(s):
*    S.w[ 1] = x[ 0] = `Main.Flap_control.PID4.D.x[1]`(t)
*    S.w[ 2] = x[ 1] = `Main.Flap_control.PID4.I.y`(t)
*
* Output variable(s):
*    S.w[11] = y[ 0] = `Main.Flap_control.F`(t)
*
* Input variable(s):
*    S.w[12] = u[ 0] = `Main.Flap_control.dx`(t)
*    S.w[13] = u[ 1] = `Main.Flap_control.x`(t)
*
* Parameter(s):
*    S.w[23] = p[ 0] = `Main.GAD` (default = .1e3)
*    S.w[24] = p[ 1] = `Main.GAI` (default = .15e5)
*    S.w[25] = p[ 2] = `Main.GAP` (default = .15e5)
*    S.w[26] = p[ 3] = `Main.TMM` (default = .8e3)
*    S.w[27] = p[ 4] = `Main.c` (default = .18e4)
*    S.w[28] = p[ 5] = `Main.Flap_control.A1.k1` (default = 1.)
*    S.w[29] = p[ 6] = `Main.Flap_control.A1.k2` (default = 1.)
*    S.w[30] = p[ 7] = `Main.Flap_control.G3.k` (default = 1.)
*    S.w[31] = p[ 8] = `Main.Flap_control.G4.k` (default = 1.)
*    S.w[32] = p[ 9] = `Main.Flap_control.PID4.Add.k1` (default = 1.)
*    S.w[33] = p[10] = `Main.Flap_control.PID4.Add.k2` (default = 1.)
*    S.w[34] = p[11] = `Main.Flap_control.PID4.Add.k3` (default = 1.)
*    S.w[35] = p[12] = `Main.Flap_control.PID4.Nd` (default = .1e4)
*    S.w[36] = p[13] = `Main.Flap_control.PID4.Td` (default = .1)
*    S.w[37] = p[14] = `Main.Flap_control.PID4.k` (default = 1.)
*    S.w[38] = p[15] = `Main.Flap_control.R1.duration` (default = 4.5)
*    S.w[39] = p[16] = `Main.Flap_control.R1.height` (default = .32)
*    S.w[40] = p[17] = `Main.Flap_control.R1.offset` (default = 0.)
*    S.w[41] = p[18] = `Main.Flap_control.R2.duration` (default = 4.5)
*    S.w[42] = p[19] = `Main.Flap_control.R2.height` (default = -.32)
*    S.w[43] = p[20] = `Main.Flap_control.R2.offset` (default = 0.)
*    S.w[44] = p[21] = `Main.Flap_control.S1.height` (default = 0.)
*    S.w[45] = p[22] = `Main.Flap_control.S1.offset` (default = 0.)
*    S.w[46] = p[23] = `Main.Flap_control.S3.height` (default = 0.)
*    S.w[47] = p[24] = `Main.Flap_control.S3.offset` (default = 0.)
*    S.w[48] = p[25] = `Main.Flap_control.S4.height` (default = 0.)
*    S.w[49] = p[26] = `Main.Flap_control.S4.offset` (default = 0.)
*    S.w[50] = p[27] = `Main.Flap_control.S5.height` (default = 0.)
*    S.w[51] = p[28] = `Main.Flap_control.S5.offset` (default = 0.)
*
************************************************/

/* No scaling - no nominals */
static double *nomfac=NULL;
/* Configurable parameters */
#define MAXERRSTRLENGTH 10000
#define MAXWARNSTRLENGTH 10000
#define EVTITER 100
#define EVTHYST 1.000000e-10
#define FMUHYST 2.000000e-10

#define SSTO 0
/* Wordsize integer definition */
#ifndef M_INT
# if defined _MINGW64 || defined X86_64_WINDOWS
#  define M_INT long long
# elif defined __x86_64__ || defined __ppc64__
#  define M_INT long
# elif defined _M_X64
#  define M_INT long long
# else
#  define M_INT int
# endif
#endif

static int errorOccured = 0;
static char errorString[MAXERRSTRLENGTH+1];
static int warningOccured = 0;
static char warningString[MAXWARNSTRLENGTH+1];

static void SolverError(double t, int term, char *errmsg)
{
	if(term) {
		sprintf(errorString,"Simulation terminated at t=%20.16e: %s\n",t,errmsg);
		errorOccured = 2;
	}
	else {
		sprintf(errorString,"Error at t=%20.16e: %s\n",t,errmsg);
		errorOccured = 1;
	}
}


static void SolverWarning(double t, char *warnmsg)
{
	if(!warningOccured) {
		sprintf(warningString,"Warning at t=%20.16e: %s\n",t,warnmsg);
		warningOccured = 1;
	}
}

/* Fixed parameters */
#define NDIFF 2
#define NDFA 2
#define NEQ 22
#define NPAR 29
#define NINP 2
#define NINPD 0
#define NDISC 9
#define NIX1 11
#define NOUT 1
#define NCON 0
#define NEVT 8

#ifndef max
#define max(a,b) (((a)>(b))?(a):(b))
#endif
#ifndef min
#define min(a,b) (((a)<(b))?(a):(b))
#endif
static double prevEventIndicators[max(NEVT, 1)];
static int firstEvtCall = 1;
static double nData[2] = {1.0*NEQ,1.0*NPAR};
static double minsamplestep = 0.001;
static int inputchange=0;

static int pchange=0;
static int pflags[]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

typedef struct {
	double *w;		/* Float workspace */
	M_INT *iw;		/* Integer workspace */
	double *wset;		/* Float workspace */
	double *psto;		/* Float projection workspace */
	double *ssto;		/* Solver storage (implicit) */
	double *jsto;		/* Jacobian storage (implicit) */
} SolverStruct;

static double dsn_zero=0.0;
static unsigned char dsn_undefC[8] = { 0, 0, 0, 0, 0, 0, 0xF8, 0x7F };
static double *dsn_undef = (double *)&dsn_undefC;
static unsigned char dsn_posinfC[8] = { 0, 0, 0, 0, 0, 0, 0xF0, 0x7F };
static double *dsn_posinf = (double *)&dsn_posinfC;
static unsigned char dsn_neginfC[8] = { 0, 0, 0, 0, 0, 0, 0xF0, 0xFF };
static double *dsn_neginf = (double *)&dsn_neginfC;
#define trunc(v) ( (v>0.0) ? floor(v) : ceil(v) )
#define IS_UNDEF(a) (a-a!=0. || (a!=0. && a-2.*a==0.))
#define UNUSED(a) ((void)(a))
static double avoidcompilerwarn() { return(dsn_zero+*dsn_undef+*dsn_posinf+*dsn_neginf); }

static void fp(int N, double T, double *Y, double *YP)
{
	double Z[1], m, v, td1;

	UNUSED(N);
	if( Y[19]==1. )
		Y[5] = Y[42];
	else if( Y[21]==1. )
		Y[5] = Y[42]+((T-8.05)*Y[41])/Y[40];
	else
		Y[5] = Y[42]+Y[41];
	Z[0] = 1.0/Y[27];
	m = Z[0];
	if( Y[16]==1. )
		v = Y[28]*Z[0]*Y[5]+Y[39];
	else if( Y[20]==1. )
		v = Y[28]*Z[0]*Y[5]+Y[39]+((T-0.05)*Y[38])/Y[37];
	else
		v = Y[28]*Z[0]*Y[5]+Y[38]+Y[39];
	if( m==0. ) {
		YP[0] = (*dsn_undef);
		return;
	}
	Y[3] = v/m;
	Y[2] = Y[3]-Y[12]*Y[29];
	if( fabs(Y[22])<1e-15 )
		YP[0] = 0.;
	else {
		if( Y[35]/Y[34]>1e-13 )
			td1 = Y[35]/Y[34];
		else
			td1 = 1e-13;
		YP[0] = (Y[2]-Y[0])/td1;
	}
	if( Y[17]==1. )
		Y[6] = Y[44];
	else
		Y[6] = Y[44]+Y[43];
	if( Y[14]==1. )
		Y[7] = Y[46];
	else
		Y[7] = Y[46]+Y[45];
	if( Y[18]==1. )
		Y[8] = Y[48];
	else
		Y[8] = Y[48]+Y[47];
	if( Y[15]==1. )
		Y[9] = Y[50];
	else
		Y[9] = Y[50]+Y[49];
	YP[1] = Y[23]*Y[2];
	if( fabs(Y[22])<1e-15 )
		Y[4] = 0.;
	else {
		if( Y[35]/Y[34]>1e-13 )
			td1 = Y[35]/Y[34];
		else
			td1 = 1e-13;
		Y[4] = (Y[22]*(Y[2]-Y[0]))/td1;
	}
}

static void otp(double T, double *Y, double *YP)
{
	double td1;

	UNUSED(T);
	UNUSED(YP);
	if( Y[25]<Y[36]*(Y[2]*Y[24]*Y[31]+Y[1]*Y[32]+Y[4]*Y[33]) )
		td1 = Y[25];
	else if( Y[36]*(Y[2]*Y[24]*Y[31]+Y[1]*Y[32]+Y[4]*Y[33])<-Y[25] )
		td1 = -Y[25];
	else
		td1 = Y[36]*(Y[2]*Y[24]*Y[31]+Y[1]*Y[32]+Y[4]*Y[33]);
	Y[10] = Y[30]*td1-Y[26]*Y[11]-Y[6]-Y[7]-Y[8]-Y[9];
}

static void eev(double T, double *Y, double *Ypre, double *EA)
{
	UNUSED(Ypre);
	EA[0] = 1.-0.3333333333333333333*T;
	EA[1] = 1.-0.09090909090909090909*T;
	EA[2] = -T+0.05;
	EA[3] = 1.-0.6666666666666666667*T;
	EA[4] = 1.-0.1052631578947368421*T;
	EA[5] = 1.-0.1242236024844720497*T;
	EA[6] = Y[37]-T+0.05;
	EA[7] = 1.+0.1242236024844720497*(Y[40]-T);
}

static int eex(int N, double T, double *Y, double *Ypre)
{
	UNUSED(T);
	UNUSED(Ypre);
	if( N==1 )
		Y[14] = 1.-Y[14];
	else if( N==2 )
		Y[15] = 1.-Y[15];
	else if( N==3 )
		Y[16] = 1.-Y[16];
	else if( N==4 )
		Y[17] = 1.-Y[17];
	else if( N==5 )
		Y[18] = 1.-Y[18];
	else if( N==6 )
		Y[19] = 1.-Y[19];
	else if( N==7 )
		Y[20] = 1.-Y[20];
	else if( N==8 )
		Y[21] = 1.-Y[21];
	else if( N==9 ) {
		if( !(-Y[25]<=Y[25]) ) {
			Y[13] = 1.;
			return(1);
		}
	}
	return(0);
}

static int cpr(double T, double *Y)
{
	double v;
	int k;

	k = 0;
	if( T<3. )
		v = 1.;
	else
		v = 0.;
	if( Y[14]!=v ) {
		Y[14] = v;
		k = 1;
	}
	if( T<11. )
		v = 1.;
	else
		v = 0.;
	if( Y[15]!=v ) {
		Y[15] = v;
		k = 1;
	}
	if( T<0.05 )
		v = 1.;
	else
		v = 0.;
	if( Y[16]!=v ) {
		Y[16] = v;
		k = 1;
	}
	if( T<1.5 )
		v = 1.;
	else
		v = 0.;
	if( Y[17]!=v ) {
		Y[17] = v;
		k = 1;
	}
	if( T<9.5 )
		v = 1.;
	else
		v = 0.;
	if( Y[18]!=v ) {
		Y[18] = v;
		k = 1;
	}
	if( T<8.05 )
		v = 1.;
	else
		v = 0.;
	if( Y[19]!=v ) {
		Y[19] = v;
		k = 1;
	}
	if( T<Y[37]+0.05 )
		v = 1.;
	else
		v = 0.;
	if( Y[20]!=v ) {
		Y[20] = v;
		k = 1;
	}
	if( T<Y[40]+8.05 )
		v = 1.;
	else
		v = 0.;
	if( Y[21]!=v ) {
		Y[21] = v;
		k = 1;
	}
	return(k);
}

static void terminate(double T, double *Y, int j)
{
	char buf[10000];

	UNUSED(Y);
	if(j==1) {
		sprintf(buf,"Modelica assertion (-Main.TMM <= Main.TMM) failed in Main.Flap_control.L2: Limiter: limits must be consistent; however, uMax (=%0.6g) < uMin (=%0.6g)",Y[25],-Y[25]);
		SolverError(T,1,buf);
	}
}

static void InitEventModes(double *tval, double *y,
	M_INT *modes, M_INT *req, M_INT *inc)
{
	int i;

	for(i=0;i<NEVT;i++) {
		if(tval[i]>0.0)
			modes[i]=1;
		else if(tval[i]<0.0)
			modes[i]=0;
		else if(req[i]>0) {
			if(y[req[i]-1]==1.0)
				modes[i]=1;
			else
				modes[i]=0;
		}
		else if(inc[i])
			modes[i]=0;
		else
			modes[i]=1;
	}
}

static int ComputeEventIndicators(double *tval, double *y,
	M_INT *modes, M_INT *req, M_INT *inc, M_INT *ivl)
{
	int i;

	for(i=0;i<NEVT;i++) {
		if(req[i]>0) {
			/* Requires triggers - have an assoc. state variable, so we
				know the expected state */
			if(y[req[i]-1]==1.0)
				tval[i]+=FMUHYST;
			else
				tval[i]-=FMUHYST;
		}
		else if(inc[i]) {
			/* Increase-only trigger */
			if(modes[i]==0)
				tval[i]-=FMUHYST;
			else
				tval[i]+=FMUHYST;
		}
		else if(ivl[i]>0) {
			/* Integer-shift trigger */
			tval[i]-=FMUHYST;
		}
		else return(-1); /* Bad event */
	}
	return(0);
}

static int CheckEvents(double *tval, double *yt, M_INT *modes,
	M_INT *oldmodes, M_INT *req, M_INT *inc, M_INT *ivl)
{
	int i,flag;

	flag=0;
	for(i=0;i<NEVT;i++) {
		if(req[i]>0) {
			/* Requires triggers - have an assoc. state variable, so we
				do not need to rely on 'oldmodes' */
			if(yt[req[i]]==1.0) {
				/* Switch orig in '+' state */
				if( tval[i]<-EVTHYST ) {
					oldmodes[i]=1; modes[i]=0; flag=1;
				}
				else {
					oldmodes[i]=1; modes[i]=1;
				}
			}
			else {
				/* Switch orig in '-' state */
				if( tval[i]>EVTHYST ) {
					oldmodes[i]=0; modes[i]=1; flag=1;
				}
				else {
					oldmodes[i]=0; modes[i]=0;
				}
			}
		}
		else if(inc[i]) {
			/* Increase-only triggers */
			if(oldmodes[i]==0 && tval[i]>EVTHYST) {
				modes[i]=1; flag=1;
			}
			else if(oldmodes[i]==1 && tval[i]<-EVTHYST ) {
				oldmodes[i]=0; modes[i]=0;
			}
		}
		else if(ivl[i]>0) {
			/* Integer-shift trigger */
			if(tval[i]<-EVTHYST) {
				oldmodes[i]=1; modes[i]=0; flag=1;
			}
			else {
				oldmodes[i]=1; modes[i]=1;
			}
		}
		else return(-1); /* Bad event */
	}
	return(flag);
}

static int RunEvents(double *w, M_INT *modes, int first,
	int termvar, int maxiter, double *psto)
{
	double t,*y,*yp,*ypre,*tval;
	M_INT *oldmodes,*inc,*req,*ivl;
	int i,flag,iter,evt,rc,failskip;

	/* Transfer data to approp. named arrays */
	t=w[0]; y=&w[1]; yp=&y[NEQ+NPAR]; ypre=&yp[NDFA]; tval=&ypre[NEQ];
	oldmodes=&modes[NEVT]; inc=&oldmodes[NEVT]; req=&inc[NEVT]; ivl=&req[NEVT];

	/* Verify that no y values are undefined */
	for(i=0;i<NEQ;i++)
		if(IS_UNDEF(y[i])) {
			if (errorOccured<=0) {
				errorOccured = 1;
				sprintf(errorString,"undefined value encountered on entry into RunEvents at t=%f",t);
			}
			return(-3);
		}
	/* Set the old modes to the new and ypre to y */
	for(i=0;i<NEVT;i++) oldmodes[i]=modes[i];
	for(i=0;i<NEQ;i++) ypre[i]=y[i];

	if(first!=1) {
		/* Check for events */
		eev(t,y,ypre,tval);
		flag=CheckEvents(tval,y-1,modes,oldmodes,req,inc,ivl);
		if(flag<0) {
			if (errorOccured<=0) {
				errorOccured = 1;
				sprintf(errorString,"internal error: bad event at t=%f",t);
			}	
			return(-5);
		}
		/* If no events, return */
		if(!first && !flag)
			return(0);
	}

	/* Iteration loop */
	failskip=0;
	for(iter=0;;iter++) {
		if( first!=1 || iter>0 )
			/* Event loop */
			for(evt=0;evt<NEVT;evt++)
				if(modes[evt]!=oldmodes[evt]) {
					rc=eex(evt+1,t,y,ypre);
					if(termvar>=0 && y[termvar]>0.0) {
						i=(int)y[termvar];
						terminate(t,y,i);
						return(i);
					}
					/* Handle RC */
					oldmodes[evt]=modes[evt];
				}

		/* Discrete equations */
		rc=eex(NEVT+1,t,y,ypre);
		/* Fail skip */
		if(rc==8 && !failskip) {
			failskip=1;
			iter--;
			if(termvar>=0) y[termvar]=0.0;
		}
		else
			failskip=0;
		if(termvar>=0 && y[termvar]>0.0) {
			i=(int)y[termvar];
			terminate(t,y,i);
			return(i);
		}
		/* Handle RC */

		/* Check for termination */
		for(i=0;i<NEQ;i++) if(y[i]!=ypre[i]) break;
		if( !failskip && i==NEQ ) return(0);

		/* Check iter limit */
		if( iter>=maxiter ) {
			if (errorOccured<=0) {
				errorOccured = 1;
				sprintf(errorString,"maximum number of event iterations reached (%li) at t=%f",(long)iter,t);
			}
			return(-1);
		}

		/* Update index-1 equations */
		if(!failskip && NIX1>0) {
			fp(NEQ,t,y,yp);
			if( IS_UNDEF(yp[0]) ) {
				if (errorOccured<=0) {
					errorOccured = 1;
					sprintf(errorString,"index-1 and derivative evaluation failure on event at t=%f",t);
				}
				return(-2);
			}
		}
		/* Verify that no y values are undefined */
		for(i=0;i<NEQ;i++)
			if(IS_UNDEF(y[i])) {
				if (errorOccured<=0) {
					errorOccured = 1;
					sprintf(errorString,"undefined value encountered during execution of RunEvents at t=%f",t);
				}
				return(-4);
			}

		/* Update pre */
		for(i=0;i<NEQ;i++) ypre[i]=y[i];
		if(failskip) continue;

		/* Evaluate event triggers, and update modes */
		eev(t,y,ypre,tval);
		flag=CheckEvents(tval,y-1,modes,oldmodes,req,inc,ivl);
		if(flag<0) {
			if (errorOccured<=0) {
				errorOccured = 1;
				sprintf(errorString,"internal error: bad event at t=%f",t);
			}
			return(-5);
		}
	}
	return(0);
}

static void SolverUpdate(SolverStruct *S, int synced, int commit)
{
	UNUSED(commit);
	if( synced ) return;
	fp(NEQ,S->w[0],&S->w[1],&S->w[NEQ+NPAR+1]);
	if(IS_UNDEF(S->w[NEQ+NPAR+1])) {
		SolverError(S->w[0],0,"index-1 and derivative evaluation failure");
		return;
	}
	otp(S->w[0],&S->w[1],&S->w[NEQ+NPAR+1]);
}

static int SolverProject(SolverStruct *S)
{
	UNUSED(S);
	return(0);
}

static void SolverOutputs(SolverStruct *S)
{
	otp(S->w[0],&S->w[1],&S->w[NEQ+NPAR+1]);
}

static void EulerStep(double h, SolverStruct *S)
{
	int i;

	S->w[0]+=h;
	for(i=1;i<=NDIFF;i++) S->w[i]+=h*S->w[NEQ+NPAR+i];
}

static void SolverSetup_sub1(SolverStruct *S)
{
	S->w[12] = -7.34249725256249777e-19;
	S->w[15] =  1.00000000000000000e+00;
	S->w[16] =  1.00000000000000000e+00;
	S->w[17] =  1.00000000000000000e+00;
	S->w[18] =  1.00000000000000000e+00;
	S->w[19] =  1.00000000000000000e+00;
	S->w[20] =  1.00000000000000000e+00;
	S->w[21] =  1.00000000000000000e+00;
	S->w[22] =  1.00000000000000000e+00;
	S->w[23] =  1.00000000000000000e+02;
	S->w[24] =  1.50000000000000000e+04;
	S->w[25] =  1.50000000000000000e+04;
	S->w[26] =  8.00000000000000000e+02;
	S->w[27] =  1.80000000000000000e+03;
	S->w[28] =  1.00000000000000000e+00;
	S->w[29] =  1.00000000000000000e+00;
	S->w[30] =  1.00000000000000000e+00;
	S->w[31] =  1.00000000000000000e+00;
	S->w[32] =  1.00000000000000000e+00;
	S->w[33] =  1.00000000000000000e+00;
	S->w[34] =  1.00000000000000000e+00;
	S->w[35] =  1.00000000000000000e+03;
	S->w[36] =  1.00000000000000006e-01;
	S->w[37] =  1.00000000000000000e+00;
	S->w[38] =  4.50000000000000000e+00;
	S->w[39] =  3.20000000000000007e-01;
	S->w[41] =  4.50000000000000000e+00;
	S->w[42] = -3.20000000000000007e-01;
}

static void SolverSetup(SolverStruct *S)
{
	int i;

	S->w[0] =  0.00000000000000000e+00;
	for(i=1;i<=NEQ+NPAR;i++) S->w[i]=0.0;
	SolverSetup_sub1(S);
	for(i=0;i<NDIFF;i++) S->w[i+NEQ+NPAR+1]=0.0;
	S->iw[2*NEVT+0] = 0; S->iw[3*NEVT+0] = 15; S->iw[4*NEVT+0] = 0;
	S->iw[2*NEVT+1] = 0; S->iw[3*NEVT+1] = 16; S->iw[4*NEVT+1] = 0;
	S->iw[2*NEVT+2] = 0; S->iw[3*NEVT+2] = 17; S->iw[4*NEVT+2] = 0;
	S->iw[2*NEVT+3] = 0; S->iw[3*NEVT+3] = 18; S->iw[4*NEVT+3] = 0;
	S->iw[2*NEVT+4] = 0; S->iw[3*NEVT+4] = 19; S->iw[4*NEVT+4] = 0;
	S->iw[2*NEVT+5] = 0; S->iw[3*NEVT+5] = 20; S->iw[4*NEVT+5] = 0;
	S->iw[2*NEVT+6] = 0; S->iw[3*NEVT+6] = 21; S->iw[4*NEVT+6] = 0;
	S->iw[2*NEVT+7] = 0; S->iw[3*NEVT+7] = 22; S->iw[4*NEVT+7] = 0;
	eev(S->w[0],&S->w[1],&S->w[1],&S->w[2*NEQ+NPAR+NDFA+1]);
	InitEventModes(&S->w[2*NEQ+NPAR+NDFA+1],&S->w[1],S->iw,&S->iw[3*NEVT],&S->iw[2*NEVT]);
}

static void SolverInitialize(SolverStruct *S)
{
	int i;

	UNUSED(i);
	eev(S->w[0],&S->w[1],&S->w[1],&S->w[2*NEQ+NPAR+NDFA+1]);
	i=RunEvents(S->w,S->iw,2,13,EVTITER,S->psto);
	if (i<0) {
		SolverError(S->w[0],0,"error running events");
		return;
	}
	else if (i>0) {
		SolverError(S->w[0],1,"error running events");
		return;
	}
	i=cpr(S->w[0],&S->w[1]);
	S->w[NEQ+NPAR+1]=0.0;
	fp(NEQ,S->w[0],&S->w[1],&S->w[NEQ+NPAR+1]);
	if(IS_UNDEF(S->w[NEQ+NPAR+1])) {
		SolverError(S->w[0],0,"index-1 and derivative evaluation failure");
		return;
	}
	i=RunEvents(S->w,S->iw,0,13,EVTITER,S->psto);
	if (i<0) {
		SolverError(S->w[0],0,"error running events");
		return;
	}
	else if (i>0) {
		SolverError(S->w[0],1,"error running events");
		return;
	}
	SolverOutputs(S);
}

/*****************************************************************************/
/* FILE fmuTemplate.c */
/*****************************************************************************/


#define FMI2_COSIMULATION
#define MODEL_GUID "{b78d3265-5f39-d288-2635-3de862df507d}"
#ifndef DISABLE_PREFIX
    #define FMI2_FUNCTION_PREFIX Flap_control_ondesign_
#endif



/* define model size */
#define NUMBER_OF_REALS 84
#define NUMBER_OF_INTEGERS 5*NEVT
#define NUMBER_OF_BOOLEANS 0
#define NUMBER_OF_STRINGS 0

/* include FMU header files, typedefs and macros */
#include "fmuTemplate.h"

/* define initial state vector and derivative vector as vectors of value references */
#define STATES {1, 2}
#define DERS   {52, 53}
#define OUTS   {11}

#ifdef FMI2_PROVIDES_DERIVATIVES
#define NIKNO 0
#define NIUNK 0
#define IKNOS { }
#define IUNKS { }
#endif

/*****************************************************************************/

#if NDIFF>0
static fmi2ValueReference vrStates[NDIFF] = STATES;
static fmi2ValueReference   vrDers[NDIFF] = DERS;
#else
static fmi2ValueReference *vrStates = NULL;
static fmi2ValueReference   *vrDers = NULL;
#endif

#if NOUT>0
static fmi2ValueReference   vrOuts[NOUT] = OUTS;
#else
static fmi2ValueReference   *vrOuts = NULL;
#endif

#ifdef FMI2_PROVIDES_DERIVATIVES
#if NIKNO>0
static fmi2ValueReference   vrIknowns[NIKNO] = IKNOS;
#else
static fmi2ValueReference   *vrIknowns = NULL;
#endif
#if NIUNK>0
static fmi2ValueReference   vrIunknowns[NIUNK] = IUNKS;
#else
static fmi2ValueReference   *vrIunknowns = NULL;
#endif
#endif

/*****************************************************************************
 * BEGIN: Private functions
 *****************************************************************************/
/*****************************************************************************/
#ifndef FMI2_COSIMULATION
static fmi2Boolean invalidNumber(ModelInstance*	comp,
								 const char*	f,
								 const char*	arg,
								 int			n,
								 int			nExpected) {
	if (n != nExpected) {
		comp->state = modelError;
		compLog(compEnv, comp->instanceName, fmi2Error,
			"error", "[%s]: Invalid argument %s = %d. Expected %d.",
			f, arg, n, nExpected);
		return fmi2True;
	}
	return fmi2False;
}
#endif
/*****************************************************************************/
static fmi2Boolean invalidState(ModelInstance*	comp,
								const char*		f,
								int				statesExpected) {
	if (!comp) return fmi2True;
	if (!(comp->state && statesExpected)) {
		comp->state = modelError;
		compLog(compEnv, comp->instanceName, fmi2Error,
			"error", "[%s]: Illegal call sequence.", f);
		return fmi2True;
	}
	return fmi2False;
}
/*****************************************************************************/
static fmi2Boolean nullPointer(	ModelInstance*	comp,
								const char*		f,
								const char*		arg,
								const void*		p) {
	if (!p) {
		comp->state = modelError;
		compLog(compEnv, comp->instanceName, fmi2Error,
			"error", "[%s]: Invalid argument %s = NULL.", f, arg);
		return fmi2True;
	}
	return fmi2False;
}
/*****************************************************************************/
static fmi2Boolean vrOutOfRange(ModelInstance*		comp,
								const char*			f,
								fmi2ValueReference	vr,
								int					end) {
	if ((int)vr >= end) {
		comp->state = modelError;
		compLog(compEnv, comp->instanceName, fmi2Error,
			"error", "[%s]: Illegal value reference %u.", f, vr);
		return fmi2True;
	}
	return fmi2False;
}
/*****************************************************************************/
static void logMessage(ModelInstance*	comp,
				const char*		f,
				const char*		e,
				fmi2Status		value) {
	compLog(compEnv, comp->instanceName, value,
			e, "[%s]: %s", f, errorString);
}
/*****************************************************************************/
static void logWarning(ModelInstance*	comp,
				const char*		f,
				const char*		e,
				fmi2Status		value) {
	compLog(compEnv, comp->instanceName, value,
			e, "[%s]: %s", f, warningString);
}
/*****************************************************************************/
static void setVidError(ModelInstance *comp, char *errstr)
{
	if (errstr)
		strcpy(comp->viderror,errstr);
	else if (errorOccured)
		strcpy(comp->viderror,errorString);
	else
		strcpy(comp->viderror,"unknown error");
	comp->vidsts = -1;
}
/*****************************************************************************/
static fmi2Status syncModel(ModelInstance *c, const char *f)
{
	ModelInstance* comp = (ModelInstance *)c;
	int i;

	if (comp->state==modelInitialized && !comp->synced) {
		if(comp->initializeMode) {
			if(comp->S.wset) {
				SolverSetup(&(comp->S));
				for(i=0;i<NUMBER_OF_REALS;i++)
					if(!IS_UNDEF(comp->S.wset[i]))
						comp->S.w[i]=comp->S.wset[i];
			}
			SolverInitialize(&(comp->S));
			if (errorOccured>0) {
				setVidError(comp,NULL);
				comp->state = modelTerminated;
				logMessage(comp, f, "error", fmi2Error);
				return fmi2Error;
			}
			else if(errorOccured<0) {
				logMessage(comp, f, "warning", fmi2Warning);
				errorOccured=0;
			}
		}
		else {
			if(comp->fmuType==fmi2ModelExchange && comp->S.wset)
				for(i=NDIFF+1;i<=NDIFF+NIX1-NINP-NINPD;i++)
					comp->S.w[i]=comp->S.wset[i];
			SolverUpdate(&(comp->S),0,0);
			if(errorOccured>0) {
				setVidError(comp,NULL);
				errorOccured=0;
				logMessage(comp, f, "error", fmi2Error);
				return fmi2Discard;
			}
			else if(errorOccured<0) {
				logMessage(comp, f, "warning", fmi2Warning);
				errorOccured=0;
			}
		}
		if(inputchange) inputchange=0;
		comp->synced = fmi2True;
		comp->jsynced = fmi2False;
	}
	return fmi2OK;
}

#ifdef FMI2_COSIMULATION
static fmi2Status SolverUpdateAndProject(fmi2Component c, int newinp, const char *f)
{
	ModelInstance* comp = (ModelInstance *)c;
	int i;

	SolverUpdate(&(comp->S),0,(newinp)?1:-1);
	if (errorOccured>0) {
		setVidError(comp,NULL);
		errorOccured = 0;
		comp->state = modelTerminated;
		logMessage(comp, f, "error", fmi2Discard);
		return fmi2Discard;
	}
	else if(errorOccured<0) {
		logMessage(comp, f, "warning", fmi2Warning);
		errorOccured=0;
	}
	comp->synced = fmi2True;
	comp->jsynced = fmi2False;

	i=SolverProject(&(comp->S));
	if(i<0 || errorOccured==1) {
		setVidError(comp,NULL);
		errorOccured = 0;
		comp->state = modelTerminated;
		logMessage(comp, f, "error", fmi2Error);
		return fmi2Error;
	}
	else if(i>0 || errorOccured==2) {
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"%s: model requested termination at t = %g",
				f,comp->S.w[0]);
		setVidError(comp,NULL);
		errorOccured = 0;
		comp->state = modelTerminated;
		logMessage(comp, f, "warning", fmi2Discard);
		return fmi2Discard;
	}
	else if(errorOccured<0) {
		logMessage(comp, f, "warning", fmi2Warning);
		errorOccured=0;
	}
	return fmi2OK;
}
#endif
/*****************************************************************************
 * END: Private functions
 *****************************************************************************/
/*****************************************************************************
 * Common functions: for FMI Model Exchange 2.0 and for FMI Co-Simulation 2.0
 *****************************************************************************/
/*****************************************************************************/
/* BEGIN: fmi2GetTypesPlatform */
const char* fmi2GetTypesPlatform() {
	return fmi2TypesPlatform;
}
/* END: fmi2GetTypesPlatform */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetVersion */
const char* fmi2GetVersion() {
	return fmi2Version;
}
/* END: fmi2GetVersion */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetDebugLogging */
fmi2Status fmi2SetDebugLogging(	fmi2Component	c,
								fmi2Boolean		loggingOn,
								size_t			nCategories,
								const fmi2String categories[]) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2SetDebugLogging", not_modelError))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK,
			"log", "fmi2SetDebugLogging: loggingOn = %d", loggingOn);
	if(nCategories>0 && categories!=NULL)
		/* No support for separate logging categories at this time */
		comp->loggingOn = fmi2True;
	else
		comp->loggingOn = loggingOn;
	return fmi2OK;
}
/* END: fmi2SetDebugLogging */
/*****************************************************************************/

static char nameME[] = "ModelExchange";
static char nameCS[] = "CoSimulation";

/*****************************************************************************/
/* BEGIN: fmi2Instantiate */
fmi2Component fmi2Instantiate(	fmi2String					instanceName,
								fmi2Type					fmuType,
								fmi2String					GUID,
								fmi2String					fmuLocation,
								const fmi2CallbackFunctions* functions,
								fmi2Boolean					visible,
								fmi2Boolean					loggingOn) {
	ModelInstance* comp;
	char * fname;
	fmi2String iname;
	int i;

	UNUSED(fmuLocation);
	UNUSED(visible);
	avoidcompilerwarn();
	if (fmuType==fmi2ModelExchange)
		fname = nameME;
	else
		fname = nameCS;

	if (!functions->logger)
		return NULL;
	if (!functions->allocateMemory || !functions->freeMemory) {
		functions->logger(NULL, instanceName, fmi2Error,
				"error", "[%s]: Callback function is not found.", fname);
		return NULL;
	}
	if (!instanceName || strlen(instanceName)==0) {
		functions->logger(NULL, instanceName, fmi2Error,
				"error", "[%s]: Instance name is not found.", fname);
		return NULL;
	}
	if (strcmp(GUID, MODEL_GUID)) {
		functions->logger(NULL, instanceName, fmi2Error,
				"error", "[%s]: Inconsistent GUID %s. Expected %s.",
				fname, GUID, MODEL_GUID);
		return NULL;
	}

	comp = (ModelInstance *)functions->allocateMemory(1,sizeof(ModelInstance));

	iname = functions->allocateMemory(strlen((char*)instanceName) + 1,sizeof(char));
	if (!iname)
		functions->logger(NULL, instanceName, fmi2Error,
				"error", "[%s]: Cannot allocate memory.", fname);
	strcpy((char*)iname, (char*)instanceName);

	if (comp) {
		comp->S.w = functions->allocateMemory(NUMBER_OF_REALS,sizeof(fmi2Real));
		if (fmuType==fmi2ModelExchange)
			comp->S.wset = functions->allocateMemory(NUMBER_OF_REALS,sizeof(fmi2Real));
		else
			comp->S.wset = NULL;
		if(NCON>0)
			comp->S.psto = functions->allocateMemory(NDIFF*(1+NCON+2*NDIFF),sizeof(fmi2Real));
		else
			comp->S.psto = NULL;
		if(SSTO>0)
			comp->S.ssto = functions->allocateMemory(NDFA*(NDFA+1),sizeof(fmi2Real));
		else
			comp->S.ssto = NULL;
		comp->S.jsto = NULL;
#ifdef FMI2_PROVIDES_DERIVATIVES
		if( (1+NDIFF+NINP)*(NDIFF+NOUT)>0 ) {
			comp->Jacobian = functions->allocateMemory((1+NDIFF+NINP)*(NDIFF+NOUT),sizeof(fmi2Real));
			if (!comp->Jacobian) {
				functions->logger(NULL, instanceName, fmi2Error,
						"error", "[%s]: Cannot allocate memory.", fname);
				return NULL;
			}
		}
		else
			comp->Jacobian = NULL;

		if( NIUNK*NIKNO>0 ) {
			comp->initJacobian = functions->allocateMemory(NIUNK*NIKNO,sizeof(fmi2Real));
			if (!comp->initJacobian) {
				functions->logger(NULL, instanceName, fmi2Error,
						"error", "[%s]: Cannot allocate memory.", fname);
				return NULL;
			}
		}
		else
			comp->initJacobian = NULL;

		if( NIUNK>0 ) {
			comp->initRes = functions->allocateMemory(NIUNK,sizeof(fmi2Real));
			if (!comp->initRes) {
				functions->logger(NULL, instanceName, fmi2Error,
						"error", "[%s]: Cannot allocate memory.", fname);
				return NULL;
			}
		}
		else
			comp->initRes = NULL;

#else
		comp->Jacobian = NULL;
		comp->initJacobian = NULL;
		comp->initRes = NULL;
#endif
		if (NUMBER_OF_INTEGERS > 0)
			comp->S.iw = functions->allocateMemory(NUMBER_OF_INTEGERS,sizeof(M_INT));
		else
			comp->S.iw = NULL;
		if (NUMBER_OF_BOOLEANS > 0)
			comp->b = functions->allocateMemory(NUMBER_OF_BOOLEANS,sizeof(fmi2Boolean));
		else
			comp->b = NULL;
		if (NUMBER_OF_STRINGS > 0) {
			comp->s = functions->allocateMemory(NUMBER_OF_STRINGS,sizeof(fmi2String));
			for (i=0; i<NUMBER_OF_STRINGS; i++)
				comp->s[i] = NULL;
		}
		else
			comp->s = NULL;
	}

	if (!comp || !comp->S.w ||	(NUMBER_OF_INTEGERS>0 && !comp->S.iw ) ||
								(NUMBER_OF_BOOLEANS>0 && !comp->b) ||
								(NUMBER_OF_STRINGS>0  && !comp->s)) {
		functions->logger(NULL, instanceName, fmi2Error,
				"error", "[%s]: Cannot allocate memory.", fname);
		return NULL;
	}

	comp->instanceName	= iname;
	comp->GUID			= MODEL_GUID;
	comp->fmuType		= fmuType;
	memcpy(&comp->functions,functions,sizeof(fmi2CallbackFunctions));
	comp->loggingOn		= loggingOn;

	if(comp->S.wset) {
		for(i=0;i<NUMBER_OF_REALS;i++)
			comp->S.wset[i]=1.0/dsn_zero;
		comp->synced			= fmi2False;
		comp->jsynced			= fmi2False;
	}
	else {
		SolverSetup(&(comp->S));
		comp->synced			= fmi2True;
		comp->jsynced			= fmi2True;
	}

	comp->initializeMode	= fmi2False;
	comp->state				= modelInstantiated;
	comp->vidsts			= 0;
	comp->minSampleStep	= minsamplestep;

	if (comp->loggingOn)
		compLog(compEnv, instanceName, fmi2OK,
			"log", "[%s]: GUID = %s", fname, GUID);

	return comp;
}
/* END: fmi2Instantiate */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2FreeInstance */
/*****************************************************************************/
void fmi2FreeInstance(fmi2Component c) {
	int i;
	ModelInstance* comp = (ModelInstance *)c;

	if (!comp) return;

	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK,
			"log", "fmi2FreeInstance");

	if (comp->instanceName)	comp->functions.freeMemory((char*)comp->instanceName);
	if (comp->S.w)			comp->functions.freeMemory(comp->S.w);
	if (comp->S.iw)			comp->functions.freeMemory(comp->S.iw);
	if (comp->S.wset)			comp->functions.freeMemory(comp->S.wset);
	if (comp->S.psto)			comp->functions.freeMemory(comp->S.psto);
	if (comp->S.ssto)			comp->functions.freeMemory(comp->S.ssto);
	if (comp->S.jsto)			comp->functions.freeMemory(comp->S.jsto);
	if (comp->b)			comp->functions.freeMemory(comp->b);
	if (comp->Jacobian)		comp->functions.freeMemory(comp->Jacobian);
	if (comp->initRes)		comp->functions.freeMemory(comp->initRes);
	if (comp->initJacobian)		comp->functions.freeMemory(comp->initJacobian);
	if (comp->s) {
		for (i=0; i<NUMBER_OF_STRINGS; i++)
			if (comp->s[i]) comp->functions.freeMemory((char*)comp->s[i]);
		comp->functions.freeMemory((char*)comp->s);
	}

	comp->functions.freeMemory(comp);
}
/* END: fmi2FreeInstance */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetupExperiment */
/*****************************************************************************/
fmi2Status fmi2SetupExperiment(	fmi2Component	c,
								fmi2Boolean		toleranceDefined,
								fmi2Real		tolerance,
								fmi2Real		startTime,
								fmi2Boolean		stopTimeDefined,
								fmi2Real		stopTime) {
	ModelInstance* comp = (ModelInstance *)c;

	UNUSED(toleranceDefined);
	UNUSED(tolerance);
	comp->S.w[0]	= startTime;
	comp->startTime	= startTime;

	if (stopTimeDefined)
		comp->stopTime = stopTime;
	else
		comp->stopTime = 0.0;

	comp->stopTimeDefined = stopTimeDefined;
	comp->vidsts = 0;
	comp->vidlasttime = -1e10;

	return fmi2OK;
}
/* END: fmi2SetupExperiment */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2EnterInitializationMode */
fmi2Status fmi2EnterInitializationMode(fmi2Component c) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2EnterInitializationMode", modelInstantiated))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK,
			"log", "fmi2EnterInitializationMode");

	/* Do not sync here - delay the sync until the first FMU query */
	comp->synced			= fmi2False;
	comp->jsynced			= fmi2False;

	comp->initializeMode	= fmi2True;
	comp->state				= modelInitialized;
	comp->vidsts			= 1;

	return fmi2OK;
}
/* END: fmi2EnterInitializationMode */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2ExitInitializationMode */
fmi2Status fmi2ExitInitializationMode(fmi2Component c) {
	ModelInstance* comp = (ModelInstance *)c;
	fmi2Status sts;
	int i;

	if (comp) {
		sts = syncModel(c,"fmi2ExitInitializationMode");
		if ( sts!=fmi2OK ) return(sts);
		comp->initializeMode = fmi2False;
		if(comp->fmuType==fmi2ModelExchange && comp->S.wset)
			for(i=NDIFF+1;i<=NDIFF+NIX1-NINP;i++)
				comp->S.wset[i]=comp->S.w[i];
		comp->jsynced =fmi2False;
		comp->vidsts = 2;
		return fmi2OK;
	}
	else
		return fmi2Error;
}
/* END: fmi2ExitInitializationMode */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2Terminate */
fmi2Status fmi2Terminate(fmi2Component c) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2Terminate", modelInitialized)) return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK,
			"log", "fmi2Terminate");

	comp->state = modelTerminated;

	return fmi2OK;
}
/* END: fmi2Terminate */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2Reset */
fmi2Status fmi2Reset(fmi2Component c) {
	ModelInstance* comp = (ModelInstance *)c;
	int i;

	if (invalidState(comp, "fmi2Reset", modelInitialized)) return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK,
			"log", "fmi2Reset");

	comp->state = modelInstantiated;
	comp->synced = fmi2False;
	comp->jsynced = fmi2False;

	if(comp->S.wset)
		for(i=0;i<NUMBER_OF_REALS;i++)
			comp->S.wset[i]=1.0/dsn_zero;
	else
		SolverSetup(&(comp->S));

	return fmi2OK;
}
/* END: fmi2Reset */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetReal */
fmi2Status fmi2GetReal(	fmi2Component			c,
						const fmi2ValueReference vr[],
						size_t					nvr,
						fmi2Real				value[]) {
	int i;
	fmi2Status sts;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetReal", validGet))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetReal", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetReal", "value[]", value))
		return fmi2Error;

#if NUMBER_OF_REALS>0
	/*for (i=0; i<(int)nvr; i++)
		if (vrOutOfRange(comp, "fmi2GetReal", vr[i], NUMBER_OF_REALS))
		return fmi2Error;*/

	if(comp->state != modelTerminated) {
		sts = syncModel(comp,"fmi2GetReal");
		if ( sts!=fmi2OK ) return sts;
	}

	for (i=0; i<(int)nvr; i++) {
		if( nomfac && vr[i]>=vrStates[0] && vr[i]<vrStates[0]+NDIFF )
			value[i] = comp->S.w[vr[i]]/nomfac[vr[i]-vrStates[0]];
		else if( nomfac && vr[i]>=vrDers[0] && vr[i]<vrDers[0]+NDIFF )
			value[i] = comp->S.w[vr[i]]/nomfac[vr[i]-vrDers[0]];
		else if (vr[i] > NUMBER_OF_REALS) {
			comp->state = modelError;
			compLog(compEnv, comp->instanceName, fmi2Error,
					"error", "[%s]: Illegal value reference %u.", "fmi2GetReal", vr[i]);
			return fmi2Error;
		}
		else
			value[i] = comp->S.w[vr[i]];
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK,
				"log", "fmi2GetReal: #r%u# = %.16g", vr[i], value[i]);
	}
#endif
	return fmi2OK;
}
/* END: fmi2GetReal */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetInteger */
fmi2Status fmi2GetInteger(	fmi2Component			c,
							const fmi2ValueReference vr[],
							size_t					nvr,
							fmi2Integer				value[]) {
	int i;
	fmi2Status sts;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetInteger", validGet))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetInteger", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetInteger", "value[]", value))
		return fmi2Error;

	if(comp->state != modelTerminated) {
		sts = syncModel(comp,"fmi2GetInteger");
		if ( sts!=fmi2OK ) return sts;
	}

	for (i=0; i<(int)nvr; i++) {
		if (vrOutOfRange(comp, "fmi2GetInteger", vr[i], NUMBER_OF_INTEGERS))
			return fmi2Error;
		else
			value[i] = (fmi2Integer)comp->S.iw[vr[i]];

		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK,
				"log", "fmi2GetInteger: #i%u# = %d", vr[i], value[i]);
	}
	return fmi2OK;
}
/* END: fmi2GetInteger */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetBoolean */
fmi2Status fmi2GetBoolean(	fmi2Component			c,
							const fmi2ValueReference vr[],
							size_t					nvr,
							fmi2Boolean				value[]) {
	int i;
	fmi2Status sts;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetBoolean", validGet))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetBoolean", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetBoolean", "value[]", value))
		return fmi2Error;

	if(comp->state != modelTerminated) {
		sts = syncModel(comp,"fmi2GetBoolean");
		if ( sts!=fmi2OK ) return sts;
	}

	for (i=0; i<(int)nvr; i++) {
		if (vrOutOfRange(comp, "fmi2GetBoolean", vr[i], NUMBER_OF_BOOLEANS))
			return fmi2Error;
		else
			value[i] = comp->b[vr[i]];

		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK,
				"log", "fmi2GetBoolean: #b%u# = %s",vr[i], value[i]? "true":"false");
	}
	return fmi2OK;
}
/* END: fmi2GetBoolean */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetString */
fmi2Status fmi2GetString(fmi2Component			c,
						const fmi2ValueReference vr[],
						size_t					nvr,
						fmi2String				value[]) {
	int i;
	fmi2Status sts;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetString", validGet))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetString", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2GetString", "value[]", value))
		return fmi2Error;

	if(comp->state != modelTerminated) {
		sts = syncModel(comp,"fmi2GetString");
		if ( sts!=fmi2OK ) return sts;
	}

	for (i=0; i<(int)nvr; i++) {
		if (-1 != -1 && vr[i] == (fmi2ValueReference)(-1))
			value[i] = comp->s[0];
		else {
			comp->state = modelError;
			compLog(compEnv, comp->instanceName, fmi2Error,
					"error", "[%s]: Illegal value reference %u.", "fmi2GetString", vr[i]);
			return fmi2Error;
		}
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
					"fmi2GetString: #s%u# = '%s'", vr[i], value[i]);
	}
	return fmi2OK;
}
/* END: fmi2GetString */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetReal */
fmi2Status fmi2SetReal(	fmi2Component			c,
						const fmi2ValueReference vr[],
						size_t					nvr,
						const fmi2Real			value[]) {
	int i;
	ModelInstance* comp = (ModelInstance *)c;
	double scalev;

	if (invalidState(comp, "fmi2SetReal", modelInstantiated|modelInitialized))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetReal", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetReal", "value[]", value))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName,
				fmi2OK, "log",
				"fmi2SetReal: nvr = %d",
				nvr);

	for (i=0; i<(int)nvr; i++) {
		if (vrOutOfRange(comp, "fmi2SetReal", vr[i], NUMBER_OF_REALS))
			return fmi2Error;
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName,
					fmi2OK, "log",
					"fmi2SetReal: #r%d# = %.16g", vr[i], value[i]);
		if( nomfac && vr[i]>=vrStates[0] && vr[i]<vrStates[0]+NDIFF )
			scalev = nomfac[vr[i]-vrStates[0]]*value[i];
		else if( nomfac && vr[i]>=vrDers[0] && vr[i]<vrDers[0]+NDIFF )
			scalev = nomfac[vr[i]-vrDers[0]]*value[i];
		else
			scalev = value[i];
		if (comp->S.w[vr[i]]!=scalev) {
#if NINP>0
			if(vr[i]>=1+NDIFF+NIX1-NINP && vr[i]<1+NDIFF+NIX1)
				inputchange=1;
#endif
#if NPAR>0
			if(comp->state==modelInitialized && comp->initializeMode==fmi2False
				&& vr[i]>=1+NEQ && vr[i]<=1+NEQ+NPAR) {
				if(pflags[vr[i]-1-NEQ])
					pchange=1;
				else {
					compLog(NULL, comp->instanceName, fmi2Error, "error",
						"fmi2SetReal: attempt to change fixed parameter after initialization.");
					return fmi2Error;
				}
			}
#endif
			comp->S.w[vr[i]] = scalev;
			if(comp->fmuType==fmi2ModelExchange && comp->S.wset)
				comp->S.wset[vr[i]] = scalev;
			comp->synced = fmi2False;
			comp->jsynced = fmi2False;
		}
	}

	return fmi2OK;
}
/* END: fmi2SetReal */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetInteger */
fmi2Status fmi2SetInteger(fmi2Component			c,
						const fmi2ValueReference vr[],
						size_t					nvr,
						const fmi2Integer		value[]) {
	int i;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2SetInteger", modelInstantiated|modelInitialized))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetInteger", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetInteger", "value[]", value))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName,
				fmi2OK, "log", "fmi2SetInteger: nvr = %d",
				nvr);

	for (i=0; i<(int)nvr; i++) {
		if (vrOutOfRange(comp, "fmi2SetInteger", vr[i], NUMBER_OF_INTEGERS))
			return fmi2Error;
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName,
					fmi2OK, "log", "fmi2SetInteger: #i%d# = %d", vr[i], value[i]);
		if (comp->S.iw[vr[i]]!=(M_INT)value[i]) {
			comp->S.iw[vr[i]] = (M_INT)value[i];
			comp->synced = fmi2False;
			comp->jsynced = fmi2False;
		}
	}

	return fmi2OK;
}
/* END: fmi2SetInteger */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetBoolean */
fmi2Status fmi2SetBoolean(fmi2Component			c,
						const fmi2ValueReference vr[],
						size_t					nvr,
						const fmi2Boolean		value[]) {
	int i;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2SetBoolean", modelInstantiated|modelInitialized))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetBoolean", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetBoolean", "value[]", value))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName,
				fmi2OK, "log", "fmi2SetBoolean: nvr = %d", nvr);
	for (i=0; i<(int)nvr; i++) {
		if (vrOutOfRange(comp, "fmi2SetBoolean", vr[i], NUMBER_OF_BOOLEANS))
			return fmi2Error;
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName,
					fmi2OK, "log",
					"fmi2SetBoolean: #b%d# = %s",
					vr[i], value[i] ? "true" : "false");
		if (comp->b[vr[i]]!=value[i]) {
			comp->b[vr[i]] = value[i];
			comp->synced = fmi2False;
			comp->jsynced = fmi2False;
		}
	}

	return fmi2OK;
}
/* END: fmi2SetBoolean */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetString */
fmi2Status fmi2SetString(fmi2Component			c,
						const fmi2ValueReference vr[],
						size_t					nvr,
						const fmi2String		value[]) {
	int i;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2SetString", modelInstantiated|modelInitialized))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetString", "vr[]", vr))
		return fmi2Error;
	if (nvr>0 && nullPointer(comp, "fmi2SetString", "value[]", value))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName,
				fmi2OK, "log", "fmi2SetString: nvr = %d",	nvr);

	for (i=0; i<(int)nvr; i++) {
		char* string = (char*)comp->s[0];
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName,
					fmi2OK, "log",
					"fmi2SetString: #s%d# = '%s'",
					vr[i], value[i]);
		if (nullPointer(comp, "fmi2SetString", "value[i]", value[i]))
			return fmi2Error;
		if (string==NULL || strlen(string) < strlen(value[i])) {
			if (string) comp->functions.freeMemory(string);
			comp->s[0] = comp->functions.allocateMemory(1+strlen(value[i]),
															sizeof(char));
			if (!comp->s[0]) {
				comp->state = modelError;
				compLog(NULL, comp->instanceName,
						fmi2Error, "error", "fmi2SetString: Out of memory.");
				return fmi2Error;
			}
		}
		strcpy((char*)comp->s[0], (char*)value[i]);
		/*comp->synced = fmi2False;*/
	}

	return fmi2OK;
}
/* END: fmi2SetString */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetFMUstate */
/*****************************************************************************/
/* Storage structure:
		State id (hard coded value)
		Data length (bytes)
		ModelInstance
		Real data storage
		Integer data storage
		Real backup data storage (only for ME)
		Jacobian storage
		Error code
		String storage
*/
#define FMUStateID 983472598

fmi2Status fmi2GetFMUstate (
	fmi2Component	c,
	fmi2FMUstate*	FMUstate
)
{
	ModelInstance* comp = (ModelInstance *)c;
	char *cur;
	fmi2Real *rcur;
	M_INT i,j,*icur,wsto,ssto,jsto,totsto;

	if (invalidState(comp, "fmi2GetFMUstate", modelInitialized))
		return fmi2Error;

	if(comp->fmuType==fmi2ModelExchange)
		wsto = NUMBER_OF_REALS*sizeof(fmi2Real);
	else
		wsto = 0;

#ifdef FMI2_PROVIDES_DERIVATIVES
	jsto=( (1+NDIFF+NINP)*(NDIFF+NOUT) + NIUNK*(NIKNO+1) )*sizeof(fmi2Real);
#else
	jsto=0;
#endif

	ssto=0;
	for(i=0;i<NUMBER_OF_STRINGS;i++)
		if(comp->s[i])
			ssto+=strlen(comp->s[i])+1;
		else
			ssto++;

	totsto = 2*sizeof(M_INT) +
				sizeof(ModelInstance) +
				NUMBER_OF_REALS*sizeof(fmi2Real) +
				NUMBER_OF_INTEGERS*sizeof(M_INT) +
				wsto +
				jsto +
				sizeof(M_INT) +
				ssto;

	/* Verify that previously allocated FMU state is of sufficient size */
	if(*FMUstate) {
		icur=(M_INT *)(*FMUstate);
		if(icur[0]!=FMUStateID) {
			/* FMUstate pointer is not previously allocated in this routine
				so no way to verify the size */
			compLog(compEnv, comp->instanceName, fmi2Warning, "warning",
				"fmi2GetFMUstate: called with non-NULL state pointer of unknown size. Assuming sufficiently large.");
		}
		else if(icur[1]<totsto) {
			comp->functions.freeMemory(*FMUstate);
			*FMUstate=NULL;
		}
	}

	if(*FMUstate==NULL)
		FMUstate[0] = (fmi2FMUstate)comp->functions.allocateMemory(1,totsto);

	cur = (char *)(*FMUstate);

	icur = (M_INT *)cur;
	icur[0] = FMUStateID;
	icur[1] = totsto;
	cur += 2*sizeof(M_INT);

	memcpy(cur,comp,sizeof(ModelInstance));
	cur += sizeof(ModelInstance);

	rcur = (fmi2Real*)cur;
	for (i=0;i<NUMBER_OF_REALS;i++)	rcur[i] = comp->S.w[i];
	cur += NUMBER_OF_REALS*sizeof(fmi2Real);

	icur = (M_INT *)cur;
	for (i=0;i<NUMBER_OF_INTEGERS;i++) icur[i] = comp->S.iw[i];
	cur += NUMBER_OF_INTEGERS*sizeof(M_INT);

	if(comp->fmuType==fmi2ModelExchange) {
		rcur = (fmi2Real*)cur;
		for (i=0;i<NUMBER_OF_REALS;i++)	rcur[i] = comp->S.wset[i];
		cur += NUMBER_OF_REALS*sizeof(fmi2Real);
	}

#ifdef FMI2_PROVIDES_DERIVATIVES
	rcur = (fmi2Real*)cur;
	for (i=0;i<(1+NDIFF+NINP)*(NDIFF+NOUT);i++)	rcur[i] = comp->Jacobian[i];
	cur += (1+NDIFF+NINP)*(NDIFF+NOUT)*sizeof(fmi2Real);

	rcur = (fmi2Real*)cur;
	for (i=0;i<NIUNK*NIKNO;i++)	rcur[i] = comp->initJacobian[i];
	cur += NIUNK*NIKNO*sizeof(fmi2Real);

	rcur = (fmi2Real*)cur;
	for (i=0;i<NIUNK;i++)	rcur[i] = comp->initRes[i];
	cur += NIUNK*sizeof(fmi2Real);
#endif

	icur = (M_INT *)cur;
	icur[0] = errorOccured;
	cur += sizeof(M_INT);

	for(i=0;i<NUMBER_OF_STRINGS;i++) {
		if(comp->s[i]) {
			for(j=0;comp->s[i][j]!='\0';j++)
				*(cur++)=comp->s[i][j];
		}
		*(cur++)='\0';
	}

	return fmi2OK;
}
/* END: fmi2GetFMUstate */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetFMUstate */
/*****************************************************************************/
fmi2Status fmi2SetFMUstate (fmi2Component	c,
							fmi2FMUstate	FMUstate) {
	ModelInstance* comp = (ModelInstance *)c;
	char *cur;
	fmi2String *scur;
	fmi2Real *rcur,*wcur,*jcur1,*jcur2,*jcur3;
	M_INT i,j,l,*icur;

	if (invalidState(comp, "fmi2SetFMUstate", modelInitialized))
		return fmi2Error;

	cur = (char *)FMUstate;
	icur = (M_INT *)cur;
	if(icur[0]!=FMUStateID) {
		compLog(compEnv, comp->instanceName, fmi2Error, "error",
			"fmi2SetFMUstate: called with invalid FMUstate");
		return(fmi2Error);
	}
	cur += 2*sizeof(M_INT);

	rcur = comp->S.w;
	icur = comp->S.iw;
	wcur = comp->S.wset;
	jcur1 = comp->Jacobian;
	jcur2 = comp->initJacobian;
	jcur3 = comp->initRes;
	scur = comp->s;
	memcpy(comp,cur,sizeof(ModelInstance));
	comp->S.w  = rcur;
	comp->S.iw = icur;
	comp->S.wset = wcur;
	comp->Jacobian = jcur1;
	comp->initJacobian = jcur2;
	comp->initRes = jcur3;
	comp->s = scur;
	cur += sizeof(ModelInstance);

	rcur = (fmi2Real *)cur;
	for(i=0;i<NUMBER_OF_REALS;i++) comp->S.w[i] = rcur[i];
	cur += NUMBER_OF_REALS*sizeof(fmi2Real);

	icur = (M_INT *)cur;
	for (i=0;i<NUMBER_OF_INTEGERS;i++) comp->S.iw[i] = icur[i];
	cur += NUMBER_OF_INTEGERS*sizeof(M_INT);

	if(comp->fmuType==fmi2ModelExchange) {
		rcur = (fmi2Real *)cur;
		for(i=0;i<NUMBER_OF_REALS;i++) comp->S.wset[i] = rcur[i];
		cur += NUMBER_OF_REALS*sizeof(fmi2Real);
	}
	else
		comp->S.wset = NULL;

#ifdef FMI2_PROVIDES_DERIVATIVES
	rcur = (fmi2Real*)cur;
	for (i=0;i<(1+NDIFF+NINP)*(NDIFF+NOUT);i++)	comp->Jacobian[i] = rcur[i];
	cur += (1+NDIFF+NINP)*(NDIFF+NOUT)*sizeof(fmi2Real);

	rcur = (fmi2Real*)cur;
	for (i=0;i<NIUNK*NIKNO;i++)	comp->initJacobian[i] = rcur[i];
	cur += NIUNK*NIKNO*sizeof(fmi2Real);

	rcur = (fmi2Real*)cur;
	for (i=0;i<NIUNK;i++)	comp->initRes[i] = rcur[i];
	cur += NIUNK*sizeof(fmi2Real);
#else
	comp->Jacobian = NULL;
	comp->initJacobian = NULL;
	comp->initRes = NULL;
#endif

	icur = (M_INT *)cur;
	errorOccured = icur[0];
	cur += sizeof(M_INT);

	for(i=0;i<NUMBER_OF_STRINGS;i++) {
		l=(comp->s[i]) ? strlen(comp->s[i])+1 : 0;
		j=strlen(cur)+1;
		if(j>l) {
			if(comp->s[i]) comp->functions.freeMemory((char *)comp->s[i]);
			comp->s[i]=(fmi2String)comp->functions.allocateMemory(1,j);
		}
		strcpy((char *)comp->s[i],cur);
		cur += j;
	}

	return fmi2OK;
}
/* END: fmi2SetFMUstate */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2FreeFMUstate */
/*****************************************************************************/
fmi2Status fmi2FreeFMUstate(fmi2Component c,
							fmi2FMUstate* FMUstate) {
	ModelInstance* comp = (ModelInstance *)c;
	M_INT *icur;

	if (invalidState(comp, "fmi2FreeFMUstate",
		modelInstantiated|modelInitialized|modelTerminated|modelError))
		return fmi2Error;

	if( *FMUstate ) {
		icur = (M_INT *)(*FMUstate);
		if(icur[0]!=FMUStateID)
			compLog(compEnv, comp->instanceName, fmi2Warning, "warning",
				"fmi2FreeFMUstate: called with invalid FMUstate");
		comp->functions.freeMemory(*FMUstate);
	}

	*FMUstate = NULL;

	return fmi2OK;
}
/* END: fmi2FreeFMUstate */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SerializedFMUstateSize */
/*****************************************************************************/
fmi2Status fmi2SerializedFMUstateSize(	fmi2Component	c,
										fmi2FMUstate	FMUstate,
										size_t			*size) {
	ModelInstance* comp = (ModelInstance *)c;
	M_INT *icur;

	if (invalidState(comp, "fmi2SerializedFMUstateSize", modelInitialized))
		return fmi2Error;

	icur = (M_INT *)FMUstate;
	if(icur[0]!=FMUStateID) {
		compLog(compEnv, comp->instanceName, fmi2Error, "error",
			"fmi2SerializedFMUstateSize: called with invalid FMUstate");
		return(fmi2Error);
	}
	*size = (size_t)icur[1];

	return fmi2OK;
}
/* END: fmi2SerializedFMUstateSize */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SerializeFMUstate */
/*****************************************************************************/
fmi2Status fmi2SerializeFMUstate(fmi2Component		c,
								fmi2FMUstate		FMUstate,
								fmi2Byte 			serializedState[],
								size_t				size) {
	ModelInstance* comp = (ModelInstance *)c;
	M_INT *icur;

	if (invalidState(comp, "fmi2SerializeFMUstate", modelInitialized))
		return fmi2Error;

	icur = (M_INT *)FMUstate;
	if(icur[0]!=FMUStateID) {
		compLog(compEnv, comp->instanceName, fmi2Error, "error",
			"fmi2SerializedFMUstate: called with invalid FMUstate");
		return fmi2Error;
	}
	if(icur[1]>(M_INT)size) {
		compLog(compEnv, comp->instanceName, fmi2Error, "error",
			"fmi2SerializedFMUstate: called with size not sufficient to contain FMUstate");
		return fmi2Error;
	}
	memcpy(serializedState, FMUstate, size);

	return fmi2OK;
}
/* END: fmi2SerializeFMUstate */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2DeSerializeFMUstate */
/*****************************************************************************/
fmi2Status fmi2DeSerializeFMUstate(	fmi2Component	c,
									const fmi2Byte	serializedState[],
									size_t			size,
									fmi2FMUstate	*FMUstate) {
	ModelInstance* comp = (ModelInstance *)c;
	M_INT *icur;

	if (invalidState(comp, "fmi2DeSerializeFMUstate", modelInitialized))
		return fmi2Error;

	icur = (M_INT *)serializedState;
	if(icur[0]!=FMUStateID) {
		compLog(compEnv, comp->instanceName, fmi2Error, "error",
			"fmi2DeSerializedFMUstate: called with serializedState not containing valid FMUstate");
		return fmi2Error;
	}
	if(icur[1]>(M_INT)size) {
		compLog(compEnv, comp->instanceName, fmi2Error, "error",
			"fmi2SerializedFMUstate: called with size not sufficient to contain serializedState");
		return fmi2Error;
	}
	FMUstate[0] = (fmi2FMUstate)comp->functions.allocateMemory(1,size);
	memcpy(*FMUstate, serializedState, size);

	return fmi2OK;
}
/* END: fmi2DeSerializeFMUstate */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetDirectionalDerivative */
/*****************************************************************************/
fmi2Status fmi2GetDirectionalDerivative(	fmi2Component			c,
										const fmi2ValueReference	vUnknown_ref[],
										size_t						nUnknown,
										const fmi2ValueReference	vKnown_ref[],
										size_t						nKnown,
										const fmi2Real				dvKnown[],
										fmi2Real					dvUnknown[]) {
#ifdef FMI2_PROVIDES_DERIVATIVES
	int i, j, k, row, col, offset;
	fmi2Status sts;
	fmi2ValueReference vrs, vrd;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetDirectionalDerivatives", modelInstantiated|modelInitialized))
		return fmi2Error;
	if (nKnown>0 && nullPointer(comp, "fmi2GetDirectionalDerivative", "vKnown_ref[]", vKnown_ref))
		return fmi2Error;
	if (nUnknown>0 && nullPointer(comp, "fmi2GetDirectionalDerivative", "vUnknown_ref[]", vUnknown_ref))
		return fmi2Error;
	if (nKnown>0 && nullPointer(comp, "fmi2GetDirectionalDerivative", "dvKnown[]", dvKnown))
		return fmi2Error;

	sts = syncModel(comp,"fmi2GetDirectionalDerivative");
	if ( sts!=fmi2OK ) return sts;

	/* Initialize unknown vector */
	for (i=0; i<nUnknown; i++) dvUnknown[i] = 0.;

	/* Get Jacobian information, dimensions, data, etc? */
	if(!comp->jsynced) {
		if(comp->initializeMode)
			initjac(comp->S.w[0],&(comp->S.w[1]),&(comp->S.w[NEQ+NPAR+1]),comp->initRes,comp->initJacobian);
		else
			intjac(comp->S.w[0],&(comp->S.w[1]),&(comp->S.w[NEQ+NPAR+1]),comp->Jacobian);
		comp->jsynced = fmi2True;
	}

	/* Order of value references :
	t, #states, #index-1(inps), #discrete, #params, #derivs, #events */

	/* Start the computation loop */
	if (comp->initializeMode) {
		offset = NIKNO;
		for (i=0; i<nKnown; i++) {
			/* Check the seed */
			if (dvKnown[i]!=0) {
				vrs = vKnown_ref[i];
				/* assert(vr>=0 && vr<NUMBER_OF_REALS); */
				col = -1;
				for (k=0; k<NIKNO; k++)
					if (vrs==vrIknowns[k]) {
						col = k;
						break;
					}
				/* Compute column i */
				for (j=0; j<nUnknown; j++) {
					vrd = vUnknown_ref[j];
					/* assert(vrd>=0 && vrd<NUMBER_OF_REALS); */
					if ( vrd==vrs ) {
						dvUnknown[j] += 1.0;
					}
					else if(col!=-1) {
						for (k=0; k<NIUNK; k++)
							if (vrd==vrIunknowns[k]) {
								dvUnknown[j] += dvKnown[i]*comp->initJacobian[k*offset+col];
								break;
							}
					}
				}
			}
		}
	}
	else {
		offset = 1+NDIFF+NINP;
		for (i=0; i<nKnown; i++) {
			/* Check the seed */
			if (dvKnown[i]!=0) {
				vrs = vKnown_ref[i];
				/* assert(vr>=0 && vr<NUMBER_OF_REALS); */
				/* Check that vKnown_ref[i] is a state or input */
				if ( vrs==0 || (vrs>=vrStates[0] && vrs<vrStates[0]+NDIFF) )
					col = vrs;
				else if(vrs>=1+NDIFF+NIX1-NINP && vrs<1+NDIFF+NIX1)
					col = vrs-(NIX1-NINP);
				else
					return fmi2Error;
				/* Compute column i */
				for (j=0; j<nUnknown; j++) {
					vrd = vUnknown_ref[j];
					/* assert(vrd>=0 && vrd<NUMBER_OF_REALS); */
					/* Check if vrd is a derivative or an output,
					it could also be an output that's a state */
					if ( vrd>=vrDers[0] && vrd<vrDers[0]+NDIFF ) {
						row = vrd-vrDers[0];
						dvUnknown[j] += dvKnown[i]*comp->Jacobian[row*offset+col];
					}
					else if( vrd>=vrStates[0] && vrd<vrStates[0]+NDIFF ) {
						if ( vrd==vrs ) dvUnknown[j] += 1.0;
					}
					else {
						for (k=0; k<NOUT; k++)
							if (vrd==vrOuts[k]) {
								/* refval-t-states+derivs: vrd-1-NDIFF+NDIFF */
								row = vrd-1;
								dvUnknown[j] += dvKnown[i]*comp->Jacobian[row*offset+col];
								break;
							}
						if (k==NOUT) return fmi2Error;
					}
				}
			}
		}
	}
	return fmi2OK;
#else
	/* Compiler warning fix */
	int i=nUnknown+nKnown;
	void *tmp;
	tmp=(void *)vUnknown_ref;
	tmp=(void *)vKnown_ref;
	tmp=(void *)dvKnown;
	tmp=(void *)dvUnknown;
	if(i>0) tmp=(void *)c;
	i=((int *)tmp)[0];
	UNUSED(vrOuts);
	/* End compiler warning fix */
	return fmi2Error;
#endif
}
/* END: fmi2GetDirectionalDerivative */
/*****************************************************************************/

#if NCON>0 && defined(WMI_PROJECTION)
/*****************************************************************************/
/* BEGIN: fmi2Projection */
/*****************************************************************************/
fmi2Status fmi2Projection(	fmi2Component	c,
								fmi2Real	P[],
								fmi2Real	projectionTolerance,
								size_t	iterationLimit,
								fmi2Boolean	apply) {
	int i;
	fmi2Status sts;
	fmi2Real S2[NDIFF];

	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2Projection", modelInstantiated|modelInitialized))
		return fmi2Error;

	sts = syncModel(comp,"fmi2Projection");
	if ( sts!=fmi2OK ) return sts;

	for(i=0;i<NDIFF;i++) S2[i] = comp->S.w[i+1];
	i=Projection(comp->S.w[0], &comp->S.w[1], projectionTolerance,
		iterationLimit, NULL, comp->S.psto);
	if( i!=0 ){
		/* Restore state */
		for(i=0;i<NDIFF;i++) comp->S.w[i+1]=S2[i];
		return fmi2Discard;
	}
	for(i=0;i<NDIFF;i++) P[i] = comp->S.w[i+1]-S2[i];

	if( !apply ){
		for(i=0;i<NDIFF;i++) comp->S.w[i+1]=S2[i];
	}

	return fmi2OK;
}
/* END: fmi2Projection */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2ProjectionStep: No longer supported */
/*****************************************************************************/
fmi2Status fmi2ProjectionStep(  fmi2Component	c,
								fmi2Real	S[]) {
	UNUSED(c);
	UNUSED(S);
	return fmi2Error;
}
/* END: fmi2ProjectionStep */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2Constraint */
/*****************************************************************************/
fmi2Status fmi2Constraint(	fmi2Component	c,
								fmi2Real	C[]) {
	int cb, cr, nblk;
	fmi2Real blkdata[2];
	fmi2Status sts;

	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2Constraint", modelInstantiated|modelInitialized))
		return fmi2Error;

	sts = syncModel(comp,"fmi2Constraint");
	if ( sts!=fmi2OK ) return sts;

	/* Iterate over Residual blocks */
	Rblkp(comp->S.w[0], &comp->S.w[1], blkdata, 0, 0);
	nblk = (int)(blkdata[0]);
	cr = 0;
	for(cb=1;cb<=nblk;cb++) {
		Rblkp(comp->S.w[0], &comp->S.w[1], &C[cr], cb, 3);
		Rblkp(comp->S.w[0], &comp->S.w[1], blkdata, cb, 1);
		cr += (int)(blkdata[0]);
	}

	return fmi2OK;
}
/* END: fmi2Constraint */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2ConstraintJacobian: No longer supported */
/*****************************************************************************/
fmi2Status fmi2ConstraintJacobian(	fmi2Component	c,
										fmi2Real	J[]) {

	/* If this function is required at some point, the code will need to be
	modified to fill in the ncon x ndiff Matrix using a sequence of calls to
	the block-based Jacobian. It is known that this will provide 0 entries
	for block dependencies on vars from a prior block, but this will only
	slow convergence of a newton approach, and be irrelevant when sufficiently
	close to the solution manifold */
	UNUSED(c);
	UNUSED(J);
	return fmi2Error;
}
/* END: fmi2ConstraintJacobian */
/*****************************************************************************/
#endif

#ifdef FMI2_COSIMULATION
/*****************************************************************************
 * FMI functions: only for FMI Co-Simulation 2.0
 *****************************************************************************/
/*****************************************************************************/
/* BEGIN: fmi2SetRealInputDerivatives */
fmi2Status fmi2SetRealInputDerivatives(	fmi2Component			c,
										const fmi2ValueReference vr[],
										size_t					nvr,
										const fmi2Integer		order[],
										const fmi2Real			value[]) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2SetRealInputDerivatives", modelInitialized))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"fmi2SetRealInputDerivatives: nvr= %d", nvr);

	UNUSED(vr);
	UNUSED(order);
	UNUSED(value);
	compLog(NULL, comp->instanceName, fmi2Error, "warning",
			"fmi2SetRealInputDerivatives: ignoring function call."
			" This model cannot interpolate inputs: canInterpolateInputs = \"fmi2False\"");

	return fmi2Warning;
}
/* END: fmi2SetRealInputDerivatives */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetRealOutputDerivatives */
fmi2Status fmi2GetRealOutputDerivatives(fmi2Component			c,
										const fmi2ValueReference vr[],
										size_t					nvr,
										const fmi2Integer		order[],
										fmi2Real				value[]) {
	int i;
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetRealOutputDerivatives", modelInitialized))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"fmi2GetRealOutputDerivatives: nvr= %d",	nvr);

	UNUSED(vr);
	UNUSED(order);
	compLog(NULL, comp->instanceName, fmi2Error, "warning",
			"fmi2GetRealOutputDerivatives: ignoring function call."
			" This model cannot compute derivatives of outputs: MaxOutputDerivativeOrder=\"0\"");

	for (i=0; i<(int)nvr; i++) value[i] = 0;

	return fmi2Warning;
}
/* END: fmi2GetRealOutputDerivatives */
/*****************************************************************************/

#define MAX_STEP  1.00000000000000000e-03

/*****************************************************************************/
/* BEGIN: fmi2DoStep */
fmi2Status fmi2DoStep(  fmi2Component	c,
						fmi2Real		currentCommunicationPoint,
						fmi2Real		communicationStepSize,
						fmi2Boolean		newStep) {

	ModelInstance* comp	= (ModelInstance *)c;
	int		i;
	double	h;
	int		n;	/* how many internal steps to perform for one fmi2DoStep */
	int		k;
	fmi2Status sts;
#if NEVT>0
	M_INT	*modes;
	int	hasEvent;
	double	eventIndicators[max(NEVT, 1)];
#endif

	if (invalidState(comp, "fmi2DoStep", modelInitialized)) return fmi2Error;

	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK, "log", "fmi2DoStep: "
				"currentCommunicationPoint = %g, "
				"communicationStepSize = %g, "
				"newStep = fmi2%s",
				currentCommunicationPoint, communicationStepSize, newStep ? "True" : "False");

	if (comp->stopTimeDefined && currentCommunicationPoint+communicationStepSize > comp->stopTime) {
		comp->state = modelError;
		return fmi2Error;
	}

	if(communicationStepSize==0) {
		n = 1;
		h = 0.0;
	}
	else {
		n = (int)floor((communicationStepSize-1e-12)/MAX_STEP)+1;
		h = communicationStepSize/n;
	}

#if NPAR>0
	if(pchange) {
		SolverInitialize(&(comp->S));
		pchange=0;
		if (errorOccured>0) {
			setVidError(comp,NULL);
			comp->state = modelTerminated;
			logMessage(comp, "fmi2DoStep", "error", fmi2Error);
			return fmi2Error;
		}
		else if(errorOccured<0) {
			logMessage(comp, "fmi2DoStep", "warning", fmi2Warning);
			errorOccured=0;
		}
	}
#endif

#if NEVT>0
	/* Run to get initial event indicators */
	if( firstEvtCall ) {
		firstEvtCall=0;
		eev(comp->S.w[0],&(comp->S.w[1]),&(comp->S.w[1]),prevEventIndicators);
		modes=comp->S.iw;
		ComputeEventIndicators(prevEventIndicators,&(comp->S.w[1]),modes,
			&modes[3*NEVT],&modes[2*NEVT],&modes[4*NEVT]);
	}
#endif

	comp->S.w[0] = currentCommunicationPoint;
	/* break the step into n steps and do a step */
	for (k=0; k<n; k++) {
#if NUMBER_OF_REALS>0
		if (h>0.0) {
			EulerStep(h,&(comp->S));
			if (errorOccured>0) {
				setVidError(comp,NULL);
				comp->state = modelTerminated;
				logMessage(comp,"EulerStep","error", fmi2Error);
				return fmi2Error;
			}
			else if(errorOccured<0) {
				logMessage(comp, "EulerStep", "warning", fmi2Warning);
				errorOccured=0;
			}
		}
		sts=SolverUpdateAndProject(comp,(k==0)?1:0,"fmi2DoStep");
		if( sts!=fmi2OK ) return sts;
#endif

#if NEVT>0
		hasEvent = 0;
		/* check for state event */
		eev(comp->S.w[0],&(comp->S.w[1]),&(comp->S.w[1]),eventIndicators);
		modes=comp->S.iw;
		ComputeEventIndicators(eventIndicators,&(comp->S.w[1]),modes,
			&modes[3*NEVT],&modes[2*NEVT],&modes[4*NEVT]);
		for (i=0; i<NEVT; i++) {
			if (eventIndicators[i] * prevEventIndicators[i] < 0) {
				hasEvent = 1;
				if (comp->loggingOn)
					compLog(compEnv, comp->instanceName, fmi2OK, "log",
							"fmi2DoStep: state event at %g, z%d crosses zero -%c-",
							comp->S.w[0], i, eventIndicators[i]<0 ? '\\' : '/');
			}
		}
		for (i=0; i<NEVT; i++) prevEventIndicators[i] = eventIndicators[i];

		if (hasEvent) {
			i = RunEvents(comp->S.w, comp->S.iw, 0, 13, EVTITER, comp->S.psto);
			if (i>0 || errorOccured==2) {
				compLog(compEnv, comp->instanceName, fmi2OK, "log",
					"fmi2DoStep: model requested termination at t = %g",
					comp->S.w[0]);
			}
			else if (i<0 || errorOccured>0) {
				logMessage(comp, "fmi2DoStep", "error", fmi2Error);
			}
			if (i || errorOccured>0) {
				setVidError(comp,NULL);
				errorOccured = 0;
				comp->state = modelTerminated;
				logMessage(comp, "fmi2DoStep", "warning", fmi2Discard);
				return fmi2Discard;
			}
			if(errorOccured<0) {
				logMessage(comp, "fmi2DoStep", "warning", fmi2Warning);
				errorOccured=0;
			}
		}
#endif

		SolverOutputs(&(comp->S));
	}

	comp->lastSuccessfulTime = currentCommunicationPoint + communicationStepSize;
	comp->vidsts = 2;

	return fmi2OK;
}
/* END: fmi2DoStep */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2CancelStep */
fmi2Status fmi2CancelStep(fmi2Component c) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2CancelStep", modelInitialized)) return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK, "log", "fmi2CancelStep");

	compLog(NULL, comp->instanceName, fmi2Error, "error",
			"fmi2CancelStep: Can be called when fmi2DoStep returned fmi2Pending."
			" This is not the case.");
	comp->state = modelError;
	return fmi2Error;
}
/* END: fmi2CancelStep */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetStatus */
fmi2Status fmi2GetStatus(	fmi2Component		c,
							const fmi2StatusKind s,
							fmi2Status*			value) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetStatus", modelInstantiated|modelInitialized))
		return fmi2Error;

	UNUSED(value);
	if (s==fmi2DoStepStatus) {
		if (comp->loggingOn) {
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"[fmi2GetStatus]: fmi2StatusKind = fmi2DoStepStatus");
			compLog(NULL, comp->instanceName, fmi2Error, "error",
				"[fmi2GetStatus]: Can be called with fmi2DoStepStatus when fmi2DoStep returned fmi2Pending."
				" This is not the case.");
		}
		return fmi2Discard;
	}
	else
		return fmi2Discard;
}
/* END: fmi2GetStatus */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetRealStatus */
fmi2Status fmi2GetRealStatus(	fmi2Component		c,
								const fmi2StatusKind s,
								fmi2Real*			value) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetRealStatus", modelInstantiated|modelInitialized))
		return fmi2Discard;

	if (s==fmi2LastSuccessfulTime) {
		if (comp->loggingOn) {
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"[fmi2GetRealStatus]: fmi2StatusKind = fmi2LastSuccessfulTime");
		}
		if (comp->state==modelTerminated) {
			*value = comp->lastSuccessfulTime;
			return fmi2OK;
		}
		else {
			compLog(NULL, comp->instanceName, fmi2Error, "error",
				"[fmi2GetRealStatus]: Can be called with fmi2LastSuccessfulTime when fmi2DoStep returned fmi2Discard."
				" This is not the case.");
			return fmi2Discard;
		}
	}
	else
		return fmi2Discard;
}
/* END: fmi2GetRealStatus */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetIntegerStatus */
fmi2Status fmi2GetIntegerStatus(fmi2Component		c,
								const fmi2StatusKind s,
								fmi2Integer*		value) {
	UNUSED(c);
	UNUSED(s);
	UNUSED(value);
	return fmi2Discard;
}
/* END: fmi2GetIntegerStatus */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetBooleanStatus */
fmi2Status fmi2GetBooleanStatus(fmi2Component		c,
								const fmi2StatusKind s,
								fmi2Boolean*		value) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetBooleanStatus", modelInstantiated|modelInitialized))
		return fmi2Discard;

	if (s==fmi2Terminated) {
		if (comp->loggingOn) {
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"[fmi2GetBooleanStatus]: fmi2StatusKind = fmi2Terminated");
		}
		if (comp->state==modelTerminated)
			*value = fmi2True;
		else
			*value = fmi2False;
		return fmi2OK;
	}
	else
		return fmi2Discard;
}
/* END: fmi2GetBooleanStatus */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetStringStatus */
fmi2Status fmi2GetStringStatus(	fmi2Component		c,
								const fmi2StatusKind s,
								fmi2String*			value) {
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState(comp, "fmi2GetStringStatus", modelInstantiated|modelInitialized))
		return fmi2Discard;

	UNUSED(value);
	if (s==fmi2PendingStatus) {
		if (comp->loggingOn) {
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"[fmi2GetStringStatus]: fmi2StatusKind = fmi2PendingStatus");
			compLog(NULL, comp->instanceName, fmi2Error, "error",
					"[fmi2GetStringStatus]: Can be called with fmi2PendingStatus when fmi2DoStep returned fmi2Pending."
					" This is not the case.");
		}
		return fmi2Discard;
	}
	else
		return fmi2Discard;
}
/* END: fmi2GetStringStatus */
/*****************************************************************************/

#else
/*****************************************************************************
 * FMI functions: only for Model Exchange 2.0
 *****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2EnterEventMode */
fmi2Status fmi2EnterEventMode(fmi2Component c) {
	ModelInstance* comp = (ModelInstance *)c;

	if (comp) {
		comp->lastEventTime = comp->S.w[0]-1.0;
		return fmi2OK;
	}
	else
		return fmi2Error;
}
/* END: fmi2EnterEventMode */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2NewDiscreteStates */
fmi2Status fmi2NewDiscreteStates(fmi2Component	c,
								fmi2EventInfo*	eventInfo) {
	ModelInstance* comp = (ModelInstance *)c;
	int i;
#if NEVT+NCON>0
	fmi2Real save[NEQ],val;
#endif
	if (invalidState(comp, "fmi2NewDiscreteStates", modelInitialized))
		return fmi2Error;
	if (nullPointer (comp, "fmi2NewDiscreteStates", "eventInfo", eventInfo))
		return fmi2Error;

	eventInfo->newDiscreteStatesNeeded				= fmi2False;
	eventInfo->nominalsOfContinuousStatesChanged	= fmi2False;
	eventInfo->valuesOfContinuousStatesChanged		= fmi2False;
	eventInfo->terminateSimulation					= fmi2False;
	eventInfo->nextEventTimeDefined					= fmi2False;
	eventInfo->nextEventTime						= -0.0;

#if NEVT+NCON>0
	for(i=0;i<NEQ;i++) save[i]=comp->S.w[i+1];
#endif
	i=SolverProject(&(comp->S));
	if (i<0 || errorOccured==1) {
		setVidError(comp,NULL);
		eventInfo->terminateSimulation = fmi2True;
		comp->state = modelTerminated;
		logMessage(comp, "fmi2NewDiscreteStates", "error", fmi2Error);
		return fmi2Error;
	}
	else if (i>0 || errorOccured==2) {
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"fmi2NewDiscreteStates: model requested termination at t = %g",
				comp->S.w[0]);
		setVidError(comp,NULL);
		eventInfo->terminateSimulation = fmi2True;
		comp->state = modelTerminated;
		logMessage(comp, "fmi2NewDiscreteStates", "warning", fmi2Discard);
		return fmi2OK;
	}
	else if(errorOccured<0) {
		logMessage(comp, "fmi2NewDiscreteStates", "warning", fmi2Warning);
		errorOccured=0;
	}
#if NEVT>0
	if (comp->S.w[0]!=comp->lastEventTime) {
		i=RunEvents(comp->S.w, comp->S.iw, 0, 13, EVTITER, comp->S.psto);
		if (i<0 || errorOccured==1) {
			setVidError(comp,NULL);
			eventInfo->terminateSimulation = fmi2True;
			comp->state = modelTerminated;
			logMessage(comp, "fmi2NewDiscreteStates", "error", fmi2Error);
			return fmi2Error;
		}
		else if (i>0 || errorOccured==2) {
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
					"fmi2NewDiscreteStates: model requested termination at t = %g",
					comp->S.w[0]);
			setVidError(comp,NULL);
			eventInfo->terminateSimulation = fmi2True;
			comp->state = modelTerminated;
			logMessage(comp, "fmi2NewDiscreteStates", "warning", fmi2Discard);
			return fmi2OK;
		}
		else if(errorOccured<0) {
			logMessage(comp, "fmi2NewDiscreteStates", "warning", fmi2Warning);
			errorOccured=0;
		}
		comp->lastEventTime = comp->S.w[0];
	}
	i=RunEvents(comp->S.w, comp->S.iw, 1, 13, EVTITER, comp->S.psto);
	if (i<0 || errorOccured==1) {
		setVidError(comp,NULL);
		eventInfo->terminateSimulation = fmi2True;
		comp->state = modelTerminated;
		logMessage(comp, "fmi2NewDiscreteStates", "error", fmi2Error);
		return fmi2Error;
	}
	else if (i>0 || errorOccured==2) {
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"fmi2NewDiscreteStates: model requested termination at t = %g",
				comp->S.w[0]);
		setVidError(comp,NULL);
		eventInfo->terminateSimulation = fmi2True;
		comp->state = modelTerminated;
		logMessage(comp, "fmi2NewDiscreteStates", "warning", fmi2Discard);
		return fmi2OK;
	}
	else if(errorOccured<0) {
		logMessage(comp, "fmi2NewDiscreteStates", "warning", fmi2Warning);
		errorOccured=0;
	}
#endif
#if NEVT+NCON>0
	for(i=0;i<NEQ;i++) {
		val=1e-15;
		if(fabs(save[i])>val) val=fabs(save[i]);
		if(fabs(comp->S.w[i+1])>val) val=fabs(comp->S.w[i+1]);
		if( fabs(comp->S.w[i+1]-save[i])>1e-12*val )
			eventInfo->valuesOfContinuousStatesChanged = fmi2True;
	}
	if(eventInfo->valuesOfContinuousStatesChanged==fmi2True)
		SolverOutputs(&(comp->S));
#endif
	return fmi2OK;
}
/* END: fmi2NewDiscreteStates */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2EnterContinuousTimeMode */
fmi2Status fmi2EnterContinuousTimeMode(fmi2Component c) {
	if (c)	return fmi2OK;
	else	return fmi2Error;
}
/* END: fmi2EnterContinuousTimeMode */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2CompletedIntegratorStep */
fmi2Status fmi2CompletedIntegratorStep(	fmi2Component	c,
										fmi2Boolean		noSetFMUStatePriorToCurrentPoint,
										fmi2Boolean*	enterEventMode,
										fmi2Boolean*	terminateSimulation) {
	ModelInstance* comp = (ModelInstance *)c;
	int i;
#if NCON>0 && defined(CONDSTEPEVENT)
	fmi2Real save[NEQ],val,drift;
#endif

	UNUSED(noSetFMUStatePriorToCurrentPoint);
	if (invalidState(comp, "fmi2CompletedIntegratorStep", modelInitialized))
		return fmi2Error;
	if (nullPointer (comp, "fmi2CompletedIntegratorStep", "enterEventMode", enterEventMode))
		return fmi2Error;
	if (nullPointer (comp, "fmi2CompletedIntegratorStep", "terminateSimulation", terminateSimulation))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"fmi2CompletedIntegratorStep");

	*terminateSimulation = fmi2False;
	if(!NDIFF) comp->synced = fmi2False;

	if (comp->synced)
		SolverUpdate(&(comp->S),1,1);
	else {
		SolverUpdate(&(comp->S),0,1);
		if (errorOccured>0) {
			setVidError(comp,NULL);
			errorOccured = 0;
			comp->state = modelTerminated;
			logMessage(comp, "fmi2CompletedIntegratorStep", "error", fmi2Discard);
			return fmi2Discard;
		}
		else if(errorOccured<0) {
			logMessage(comp, "fmi2CompletedIntegratorStep", "warning", fmi2Warning);
			errorOccured=0;
		}
		comp->synced = fmi2True;
		comp->jsynced = fmi2False;
	}
	if(comp->fmuType==fmi2ModelExchange && comp->S.wset)
		for(i=NDIFF+1;i<=NDIFF+NIX1-NINP;i++)
			comp->S.wset[i]=comp->S.w[i];
	SolverOutputs(&(comp->S));
	if( comp->S.w[0]>=(comp->vidlasttime+comp->minSampleStep)*(1-1e-15) ) {
		comp->vidsts=2;
		comp->vidlasttime=comp->S.w[0];
	}

#if !defined(WMI_PROJECTION) && NCON>0
#   if defined(CONDSTEPEVENT)
	for(i=0;i<NEQ;i++) save[i]=comp->S.w[i+1];
	i=SolverProject(&(comp->S));
	if (i<0 || errorOccured>=1) {
		errorOccured=0;
		*enterEventMode = fmi2True;
	}
	else if (i>0) {
		setVidError(comp,NULL);
		comp->state = modelTerminated;
		*terminateSimulation = fmi2True;
		logMessage(comp, "fmi2CompletedIntegratorStep", "error", fmi2Discard);
		return fmi2OK;
	}
	else {
		drift=0.0;
		for(i=0;i<NEQ;i++) {
			val=1e-15;
			if(fabs(save[i])>val) val=fabs(save[i]);
			if(fabs(comp->S.w[i+1])>val) val=fabs(comp->S.w[i+1]);
			val=fabs(comp->S.w[i+1]-save[i])/val;
			if(val>drift) drift=val;
		}
		val=(CONTOL<1e-8) ? 1e-10 : 0.01*CONTOL;
		if(drift>val)
			*enterEventMode = fmi2True;
		else
			*enterEventMode = fmi2False;
	}
	for(i=0;i<NEQ;i++) comp->S.w[i+1]=save[i];
#   else
	*enterEventMode = fmi2True;
#   endif
#else
	*enterEventMode = fmi2False;
#endif

	return fmi2OK;
}
/* END: fmi2CompletedIntegratorStep */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetTime */
fmi2Status fmi2SetTime(	fmi2Component	c,
						fmi2Real		time) {
	ModelInstance* comp = (ModelInstance *)c;
	if (invalidState(comp, "fmi2SetTime", modelInstantiated|modelInitialized))
		return fmi2Error;
	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"fmi2SetTime: time = %.16g", time);
	if (comp->S.w[0] != time) {
		comp->S.w[0] = time;
		comp->synced = fmi2False;
		comp->jsynced = fmi2False;
	}
	return fmi2OK;
}
/* END: fmi2SetTime */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2SetContinuousStates */
fmi2Status fmi2SetContinuousStates(	fmi2Component	c,
									const fmi2Real	x[],
									size_t			nx){
	ModelInstance* comp = (ModelInstance *)c;
#if NDIFF>0
	double scalev;
	int i;
	fmi2ValueReference vr;
#endif

	if (invalidState (comp, "fmi2SetContinuousStates", modelInitialized))
		return fmi2Error;
	if (invalidNumber(comp, "fmi2SetContinuousStates", "nx", nx, NDIFF))
		return fmi2Error;
#if NDIFF>0
	if (nullPointer  (comp, "fmi2SetContinuousStates", "x[]", x))
		return fmi2Error;

	for (i=0; i<(int)nx; i++) {
		vr = vrStates[i];
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
					"fmi2SetContinuousStates: #r%d# = %.16g", vr, x[i]);
		/*assert(vr>=0 && vr<NUMBER_OF_REALS);*/
		if( nomfac )
			scalev = nomfac[i]*x[i];
		else
			scalev = x[i];
		if (comp->S.w[vr] != scalev) {
			comp->S.w[vr] = scalev;
			comp->synced = fmi2False;
			comp->jsynced = fmi2False;
		}
	}
#else
	UNUSED(x);
#endif
	return fmi2OK;
}
/* END: fmi2SetContinuousStates */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetDerivatives */
fmi2Status fmi2GetDerivatives(	fmi2Component	c,
								fmi2Real		derivatives[],
								size_t			nx) {
#if NDIFF>0
	int i;
#endif
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState (comp, "fmi2GetDerivatives", validGet))
		return fmi2Error;
	if (invalidNumber(comp, "fmi2GetDerivatives", "nx", nx, NDIFF))
		return fmi2Error;
	if (nullPointer  (comp, "fmi2GetDerivatives", "derivatives[]", derivatives))
		return fmi2Error;

#if NDIFF>0
	if (comp->state==modelInitialized && !comp->synced) {
		SolverUpdate(&(comp->S),0,0);
		if(errorOccured>0) {
			setVidError(comp,NULL);
			errorOccured=0;
			logMessage(comp, "fmi2GetDerivatives", "error", fmi2Discard);
			return fmi2Discard;
		}
		else if(errorOccured<0) {
			logMessage(comp, "fmi2GetDerivatives", "warning", fmi2Warning);
			errorOccured=0;
		}
		comp->synced = fmi2True;
		comp->jsynced = fmi2False;
	}
	for (i=0; i<(int)nx; i++) {
		if( nomfac )
			derivatives[i] = comp->S.w[vrDers[i]]/nomfac[i];
		else
			derivatives[i] = comp->S.w[vrDers[i]];
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
					"fmi2GetDerivatives: #r%d# = %.16g",	vrDers[i], derivatives[i]);
	}
#endif
	return fmi2OK;
}
/* END: fmi2GetDerivatives */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetEventIndicators */
fmi2Status fmi2GetEventIndicators(	fmi2Component	c,
									fmi2Real		eventIndicators[],
									size_t			ni) {
#if NEVT>0
	int i;
	M_INT *modes;
	fmi2Status sts;
#endif
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState (comp, "fmi2GetEventIndicators", validGet))
		return fmi2Error;
	if (invalidNumber(comp, "fmi2GetEventIndicators", "ni", ni, NEVT))
		return fmi2Error;

#if NEVT>0
	sts = syncModel(c,"fmi2GetEventIndicators");
	if ( sts!=fmi2OK ) return(sts);
	eev(comp->S.w[0],&(comp->S.w[1]),&(comp->S.w[1]),eventIndicators);
	modes=comp->S.iw;
	ComputeEventIndicators(eventIndicators,&(comp->S.w[1]),modes,
		&modes[3*NEVT],&modes[2*NEVT],&modes[4*NEVT]);
	for (i=0; i<(int)ni; i++) {
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
					"fmi2GetEventIndicators: z%d = %.16g",
					i, eventIndicators[i]);
	}
#else
	UNUSED(eventIndicators);
#endif
	return fmi2OK;
}
/* END: fmi2GetEventIndicators */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetContinuousStates */
fmi2Status fmi2GetContinuousStates(	fmi2Component	c,
									fmi2Real		states[],
									size_t			nx) {
#if NDIFF>0
	int i;
	fmi2Status sts;
#endif
	ModelInstance* comp = (ModelInstance *)c;

	if (invalidState (comp, "fmi2GetContinuousStates", validGet))
		return fmi2Error;
	if (invalidNumber(comp, "fmi2GetContinuousStates", "nx", nx, NDIFF))
		return fmi2Error;
#if NDIFF>0
	if (nullPointer  (comp, "fmi2GetContinuousStates", "states[]", states))
		return fmi2Error;

	sts = syncModel(c,"fmi2GetContinuousStates");
	if ( sts!=fmi2OK ) return(sts);
	for (i=0; i<(int)nx; i++) {
		if( nomfac )
			states[i] = comp->S.w[vrStates[i]]/nomfac[i];
		else
			states[i] = comp->S.w[vrStates[i]];
		if (comp->loggingOn)
			compLog(compEnv, comp->instanceName, fmi2OK, "log",
					"fmi2GetContinuousStates: #r%u# = %.16g", vrStates[i], states[i]);
	}
#else
	UNUSED(states);
#endif
	return fmi2OK;
}
/* END: fmi2GetContinuousStates */
/*****************************************************************************/

/*****************************************************************************/
/* BEGIN: fmi2GetNominalsOfContinuousStates */
fmi2Status fmi2GetNominalsOfContinuousStates(fmi2Component	c,
											fmi2Real		x_nominal[],
											size_t			nx) {
	ModelInstance* comp = (ModelInstance *)c;
	int i;

	if (invalidState (comp, "fmi2GetNominalsOfContinuousStates", validGet))
		return fmi2Error;
	if (invalidNumber(comp, "fmi2GetNominalsOfContinuousStates", "nx", nx, NDIFF))
		return fmi2Error;
	if (nullPointer  (comp, "fmi2GetNominalsOfContinuousStates", "x_nominal[]", x_nominal))
		return fmi2Error;

	if (comp->loggingOn)
		compLog(compEnv, comp->instanceName, fmi2OK, "log",
				"fmi2GetNominalsOfContinuousStates: x_nominal[0..%d] = 1.0", nx-1);
	if( nomfac )
		for (i=0; i<(int)nx; i++) x_nominal[i] = 1.0/nomfac[i-1];
	else
		for (i=0; i<(int)nx; i++) x_nominal[i] = 1.0;

	return fmi2OK;
}
/* END: fmi2GetNominalsOfContinuousStates */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* Special purpose data communication functions */

typedef fmi2Status getMapleSimVideoDataLengthTYPE(fmi2Component, fmi2Integer *);
#define getMapleSimVideoDataLength fmi2FullName(getMapleSimVideoDataLength)
FMI2_Export getMapleSimVideoDataLengthTYPE getMapleSimVideoDataLength;

fmi2Status getMapleSimVideoDataLength(fmi2Component c, fmi2Integer *len)
{
	ModelInstance* comp = (ModelInstance *)c;

	if(comp->vidsts==0) {
		*len=0;
		return(fmi2Warning);
	}
	else if(comp->vidsts==1)
		*len=2+NPAR;
	else if(comp->vidsts==2)
		*len=NEQ+1;
	else if(comp->vidsts==-1)
		*len=2+strlen(comp->viderror)/8;
	else {
		*len=0;
		return(fmi2Error);
	}
	return(fmi2OK);
}

typedef fmi2Status getMapleSimVideoDataTYPE(fmi2Component, fmi2Real *);
#define getMapleSimVideoData fmi2FullName(getMapleSimVideoData)
FMI2_Export getMapleSimVideoDataTYPE getMapleSimVideoData;

fmi2Status getMapleSimVideoData(fmi2Component c, fmi2Real *data)
{
	ModelInstance* comp = (ModelInstance *)c;

	if(comp->vidsts==0)
		return(fmi2Error);
	else if(comp->vidsts==1) {
		data[0]=nData[0];
		data[1]=nData[1];
		memcpy(&data[2],&comp->S.w[NEQ+1],NPAR*sizeof(fmi2Real));
	}
	else if(comp->vidsts==2)
		memcpy(data,comp->S.w,(NEQ+1)*sizeof(fmi2Real));
	else if(comp->vidsts==-1) {
		data[0]=-1e10;
		memcpy(&data[1],comp->viderror,strlen(comp->viderror)+1);
	}
	else
		return(fmi2Error);
	comp->vidsts=0;
	return(fmi2OK);
}

